/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.sodium;

import aztech.modern_industrialization.MI;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class SodiumCompat {
    @Nullable
    private static final MethodHandle METHOD_HANDLE;

    public static void markSpriteActive(TextureAtlasSprite sprite) {
        if (sprite != null && METHOD_HANDLE != null) {
            try {
                METHOD_HANDLE.invokeExact(sprite);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to invoke SpriteUtil#markSpriteActive", e);
            }
        }
    }

    static {
        MethodHandle handle;
        block2: {
            handle = null;
            try {
                handle = MethodHandles.lookup().findStatic(Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil"), "markSpriteActive", MethodType.methodType(Void.TYPE, TextureAtlasSprite.class));
                MI.LOGGER.info("Loaded Modern Industrialization Sodium active sprite compat.");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                if (!ModList.get().isLoaded("embeddium")) break block2;
                MI.LOGGER.error("Failed to load Modern Industrialization Sodium active sprite compat.", (Throwable)e);
            }
        }
        METHOD_HANDLE = handle;
    }
}

