/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ReiMachineRecipes {
    public static final Map<ResourceLocation, MachineCategoryParams> categories = new TreeMap<ResourceLocation, MachineCategoryParams>();
    public static final Map<ResourceLocation, List<ClickAreaCategory>> machineToClickAreaCategory = new HashMap<ResourceLocation, List<ClickAreaCategory>>();
    public static final Map<ResourceLocation, Rectangle> machineToClickArea = new HashMap<ResourceLocation, Rectangle>();
    public static final List<MultiblockShape> multiblockShapes = new ArrayList<MultiblockShape>();

    public static void registerCategory(ResourceLocation machine, MachineCategoryParams params) {
        if (categories.put(machine, params) != null) {
            throw new IllegalStateException("Machine was already registered: " + String.valueOf(machine));
        }
    }

    public static void registerWorkstation(ResourceLocation machine, ResourceLocation item) {
        MachineCategoryParams params = categories.get(machine);
        if (params == null) {
            throw new NullPointerException("Machine params may not be null for machine " + String.valueOf(machine));
        }
        params.workstations.add(item);
    }

    public static void registerRecipeCategoryForMachine(ResourceLocation machine, ResourceLocation category) {
        ReiMachineRecipes.registerRecipeCategoryForMachine(machine, category, MachineScreenPredicate.ANY);
    }

    public static void registerRecipeCategoryForMachine(ResourceLocation machine, ResourceLocation category, MachineScreenPredicate screenPredicate) {
        machineToClickAreaCategory.computeIfAbsent(machine, k -> new ArrayList()).add(new ClickAreaCategory(category, screenPredicate));
    }

    public static void registerMachineClickArea(ResourceLocation machine, Rectangle clickArea) {
        machineToClickArea.put(machine, clickArea);
    }

    public static void registerMultiblockShape(ResourceLocation machine, ShapeTemplate shapeTemplate) {
        ReiMachineRecipes.registerMultiblockShape(machine, shapeTemplate, null);
    }

    public static void registerMultiblockShape(String machine, ShapeTemplate shapeTemplate) {
        ReiMachineRecipes.registerMultiblockShape(MI.id(machine), shapeTemplate);
    }

    public static void registerMultiblockShape(ResourceLocation machine, ShapeTemplate shapeTemplate, @Nullable String alternative) {
        multiblockShapes.add(new MultiblockShape(machine, shapeTemplate, alternative));
    }

    public static void registerMultiblockShape(String machine, ShapeTemplate shapeTemplate, @Nullable String alternative) {
        ReiMachineRecipes.registerMultiblockShape(MI.id(machine), shapeTemplate, alternative);
    }

    public static enum MachineScreenPredicate {
        ANY,
        MULTIBLOCK;

    }

    public static class ClickAreaCategory {
        public final ResourceLocation category;
        public final MachineScreenPredicate predicate;

        ClickAreaCategory(ResourceLocation category, MachineScreenPredicate predicate) {
            this.category = category;
            this.predicate = predicate;
        }
    }

    public record MultiblockShape(ResourceLocation machine, ShapeTemplate shapeTemplate, @Nullable String alternative) {
    }
}

