/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.bindings.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ItemInputComponent
extends SimpleRecipeComponent<MachineRecipe.ItemInput> {
    public static final ItemInputComponent ITEM_INPUT = new ItemInputComponent();

    public ItemInputComponent() {
        super("modern_industrialization:item_input", MachineRecipe.ItemInput.CODEC, SizedIngredientWrapper.TYPE_INFO);
    }

    public MachineRecipe.ItemInput wrap(Context cx, KubeRecipe recipe, Object from) {
        SizedIngredient sizedIngredient = (SizedIngredient)cx.jsToJava(from, this.typeInfo());
        return new MachineRecipe.ItemInput(sizedIngredient.ingredient(), sizedIngredient.count(), 1.0f);
    }

    public boolean matches(Context cx, KubeRecipe recipe, MachineRecipe.ItemInput value, ReplacementMatchInfo match) {
        ItemMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof ItemMatch && (m = (ItemMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    public MachineRecipe.ItemInput replace(Context cx, KubeRecipe recipe, MachineRecipe.ItemInput original, ReplacementMatchInfo match, Object with) {
        if (this.matches(cx, recipe, original, match)) {
            Ingredient withJava = (Ingredient)cx.jsToJava(with, IngredientJS.TYPE_INFO);
            return new MachineRecipe.ItemInput(withJava, original.amount(), original.probability());
        }
        return original;
    }

    public boolean isEmpty(MachineRecipe.ItemInput value) {
        return value.amount() <= 0 || value.ingredient().isEmpty();
    }

    public void buildUniqueId(UniqueIdBuilder builder, MachineRecipe.ItemInput value) {
        TagKey tag = IngredientWrapper.tagKeyOf((Ingredient)value.ingredient());
        if (tag != null) {
            builder.append(tag.location());
        } else {
            ItemStack first = ((IngredientKJS)IngredientKJS.class.cast(value.ingredient())).kjs$getFirst();
            if (!first.isEmpty()) {
                builder.append(((RegistryObjectKJS)RegistryObjectKJS.class.cast(first)).kjs$getIdLocation());
            }
        }
    }
}

