/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidOutputComponent
extends SimpleRecipeComponent<MachineRecipe.FluidOutput> {
    public static final FluidOutputComponent FLUID_OUTPUT = new FluidOutputComponent();

    public FluidOutputComponent() {
        super("modern_industrialization:fluid_output", MachineRecipe.FluidOutput.CODEC, FluidWrapper.TYPE_INFO);
    }

    public MachineRecipe.FluidOutput wrap(Context cx, KubeRecipe recipe, Object from) {
        FluidStack fs = FluidWrapper.wrap((RegistryAccessContainer)RegistryAccessContainer.of((Context)cx), (Object)from);
        return new MachineRecipe.FluidOutput(fs.getFluid(), fs.getAmount(), 1.0f);
    }

    public boolean matches(Context cx, KubeRecipe recipe, MachineRecipe.FluidOutput value, ReplacementMatchInfo match) {
        FluidMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof FluidMatch && (m = (FluidMatch)replacementMatch).matches(cx, new FluidStack(value.fluid(), 1), match.exact());
    }

    public MachineRecipe.FluidOutput replace(Context cx, KubeRecipe recipe, MachineRecipe.FluidOutput original, ReplacementMatchInfo match, Object with) {
        if (this.matches(cx, recipe, original, match)) {
            FluidStack fs = FluidWrapper.wrap((RegistryAccessContainer)RegistryAccessContainer.of((Context)cx), (Object)with);
            return new MachineRecipe.FluidOutput(fs.getFluid(), original.amount(), original.probability());
        }
        return original;
    }

    public boolean isEmpty(MachineRecipe.FluidOutput value) {
        return value.amount() <= 0L || value.fluid().isSame(Fluids.EMPTY);
    }

    public void buildUniqueId(UniqueIdBuilder builder, MachineRecipe.FluidOutput value) {
        if (!this.isEmpty(value)) {
            builder.append(value.fluid().builtInRegistryHolder().getKey().location());
        }
    }
}

