/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.attributes;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.attributes.DisplayNamedAttribute;
import aztech.modern_industrialization.items.tools.QuantumSword;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;

public class InfiniteDamageAttribute
extends DisplayNamedAttribute {
    private static final String INFINITY = "\u221e";

    public InfiniteDamageAttribute() {
        super(MIText.AttributeInfiniteDamage.getTranslationKey(), 0.0);
    }

    public ResourceLocation getBaseId() {
        return QuantumSword.BASE_INFINITE_DAMAGE;
    }

    public MutableComponent toValueComponent(AttributeModifier.Operation operation, double value, TooltipFlag flag) {
        return Component.literal((String)INFINITY);
    }

    public MutableComponent toBaseComponent(double value, double entityBase, boolean merged, TooltipFlag flag) {
        String stringValue = value > (double)1.0E-5f ? INFINITY : FORMAT.format(0L);
        MutableComponent comp = Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{stringValue, Component.translatable((String)this.getTooltipDescriptionId())});
        if (flag.isAdvanced() && !merged) {
            MutableComponent debugInfo = Component.literal((String)" ").append((Component)Component.translatable((String)"neoforge.attribute.debug.base", (Object[])new Object[]{FORMAT.format(entityBase), FORMAT.format(value - entityBase)}).withStyle(ChatFormatting.GRAY));
            comp.append((Component)debugInfo);
        }
        return comp;
    }

    @Override
    public String getTooltipDescriptionId() {
        return "attribute.name.generic.attack_damage";
    }
}

