/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.lwjgl.opengl.GL11;

public class GuiCraftingPlanFlat
extends AbstractWidget {
    private static final int COLUMNS = 2;
    private static final int COLUMN_PADDING = 2;
    private static final int ELEMENT_WIDTH = 110;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlanFlat(AbstractContainerScreen parentGui, ITerminalCraftingPlanFlat<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 0, 0, (Component)Component.literal((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlanFlat.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows((int)Math.ceil(this.visibleElements.size() / 2));
        this.label = L10NHelpers.localize((String)craftingPlan.getUnlocalizedLabel(), (Object[])new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlanFlat guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        this.refreshList();
    }

    protected void refreshList() {
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    public void drawGuiContainerLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        int column = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(guiGraphics, element, guiLeft + this.getX() + column * 112, guiTop + this.getY() + offsetY, 110 + (column == 0 ? 1 : 0), 16, layer, partialTick, mouseX, mouseY);
            if (++column < 2) continue;
            column = 0;
            offsetY += 18;
        }
    }

    private void drawElement(GuiGraphics guiGraphics, Element element, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            guiGraphics.fill(x, y, x + width, y + height + 1, element.getColor());
        }
        int xOriginal = x;
        IPrototypedIngredient<?, ?> output = element.getInstance();
        IngredientComponent ingredientComponent = output.getComponent();
        long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
        int finalX = x;
        int finalY = y;
        ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).ifPresent(h -> h.drawInstance(guiGraphics, output.getPrototype(), quantity, "", this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            int moved = 0;
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CHEST), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)Minecraft.getInstance().font, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.stored", (Object[])new Object[]{element.getStorageQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getToCraftQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)Minecraft.getInstance().font, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.to_craft", (Object[])new Object[]{element.getToCraftQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getCraftingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)Minecraft.getInstance().font, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting", (Object[])new Object[]{element.getCraftingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getMissingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.BARRIER), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)Minecraft.getInstance().font, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.missing", (Object[])new Object[]{element.getMissingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected static void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float scale) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(scale, scale, scale);
        RenderSystem.applyModelViewMatrix();
        GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        Lighting.setupFor3DItems();
        GlStateManager._enableDepthTest();
        GL11.glEnable((int)2929);
        guiGraphics.renderItem(itemStack, 0, 0);
        renderItem.renderItemDecorations(Minecraft.getInstance().font, itemStack, 0, 0, "");
        Lighting.setupForFlatItems();
        guiGraphics.pose().popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / 20L;
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.duration", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.label, this.guiLeft + this.getX() + 110 + 8, this.guiTop + this.getY() - 13, 0xFFFFFF);
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlanFlat.getDurationString(this.tickDuration);
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)fontRenderer, (String)durationString, (int)(this.guiLeft + this.getX() + 200), (int)(this.guiTop + this.getY() - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        if (this.channel != -1) {
            String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{this.channel});
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)fontRenderer, (String)channelString, (int)(this.guiLeft + this.getX() + 200), (int)(this.guiTop + this.getY() - 8), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        if (this.initiatorName != null) {
            String initiatorString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.owner", (Object[])new Object[]{this.initiatorName});
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), (Font)fontRenderer, (String)initiatorString, (int)(this.guiLeft + this.getX() - 4), (int)(this.guiTop + this.getY() - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        this.drawGuiContainerLayer(guiGraphics, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(guiGraphics, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scroll) {
        return this.scrollBar.mouseScrolled(mouseX, mouseY, mouseZ, scroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.mouseDragged(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlanFlat<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        for (ITerminalCraftingPlanFlat.IEntry entry : craftingPlan.getEntries()) {
            GuiCraftingPlanFlat.addElements(entry, elements);
        }
        return elements;
    }

    protected static void addElements(ITerminalCraftingPlanFlat.IEntry craftingPlan, List<Element> elements) {
        elements.add(new Element(craftingPlan.getInstance(), craftingPlan.getQuantityInStorage(), craftingPlan.getQuantityToCraft(), craftingPlan.getQuantityCrafting(), craftingPlan.getQuantityMissing()));
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static class Element {
        private final IPrototypedIngredient<?, ?> instance;
        private final long storageQuantity;
        private final long toCraftQuantity;
        private final long craftingQuantity;
        private final long missingQuantity;

        public Element(IPrototypedIngredient<?, ?> instance, long storageQuantity, long toCraftQuantity, long craftingQuantity, long missingQuantity) {
            this.instance = instance;
            this.storageQuantity = storageQuantity;
            this.toCraftQuantity = toCraftQuantity;
            this.craftingQuantity = craftingQuantity;
            this.missingQuantity = missingQuantity;
        }

        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getToCraftQuantity() {
            return this.toCraftQuantity;
        }

        public long getCraftingQuantity() {
            return this.craftingQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            if (this.getMissingQuantity() > 0L) {
                return Helpers.RGBAToInt((int)250, (int)10, (int)13, (int)150);
            }
            if (this.getCraftingQuantity() > 0L) {
                return Helpers.RGBAToInt((int)43, (int)174, (int)231, (int)150);
            }
            if (this.getToCraftQuantity() > 0L) {
                return Helpers.RGBAToInt((int)243, (int)245, (int)150, (int)150);
            }
            return Helpers.RGBAToInt((int)43, (int)231, (int)47, (int)150);
        }
    }
}

