/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.klikli_dev.theurgy.logistics.Wire;
import com.klikli_dev.theurgy.logistics.Wires;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageAddWires;
import com.klikli_dev.theurgy.network.messages.MessageRemoveWires;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;

public class WireSync {
    private static final WireSync instance = new WireSync();
    private final SetMultimap<UUID, ChunkPos> playerToWatchedChunk = HashMultimap.create();
    private final SetMultimap<ChunkPos, UUID> watchedChunkToPlayers = HashMultimap.create();

    public static WireSync get() {
        return instance;
    }

    public void sendRemoveWireToWatchingPlayers(ServerLevel level, Wire wire) {
        Set<UUID> players = this.getWatchingPlayers(level, wire);
        MessageRemoveWires message = new MessageRemoveWires(Set.of(wire));
        for (UUID playerUUID : players) {
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(playerUUID);
            Networking.sendTo(player, message);
        }
    }

    public void sendAddWireToWatchingPlayers(ServerLevel level, Wire wire) {
        Set<UUID> players = this.getWatchingPlayers(level, wire);
        MessageAddWires message = new MessageAddWires(Set.of(wire));
        for (UUID playerUUID : players) {
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(playerUUID);
            Networking.sendTo(player, message);
        }
    }

    private Set<UUID> getWatchingPlayers(ServerLevel level, Wire wire) {
        ObjectOpenHashSet players = new ObjectOpenHashSet();
        Set<ChunkPos> chunks = Wires.get((Level)level).getChunks(wire);
        for (ChunkPos chunk : chunks) {
            Set playersInChunk = this.watchedChunkToPlayers.get((Object)chunk);
            players.addAll(playersInChunk);
        }
        return players;
    }

    private void sendAddWiresInChunk(ServerPlayer player, ChunkPos chunkPos) {
        Wires wires = Wires.get(player.level());
        Networking.sendTo(player, new MessageAddWires(wires.getWires(chunkPos)));
    }

    private void sendRemoveWiresInChunk(ServerPlayer player, ChunkPos chunkPos) {
        Wires manager = Wires.get(player.level());
        Set<Wire> wires = manager.getWires(chunkPos);
        ObjectOpenHashSet wiresToRemove = new ObjectOpenHashSet();
        for (Wire wire : wires) {
            Set<ChunkPos> otherChunksForWire = manager.getChunks(wire);
            if (otherChunksForWire.size() == 1) {
                wiresToRemove.add((Object)wire);
                continue;
            }
            boolean isStillWatched = false;
            for (ChunkPos otherChunk : otherChunksForWire) {
                if (!this.playerToWatchedChunk.containsEntry((Object)player.getUUID(), (Object)otherChunk)) continue;
                isStillWatched = true;
                break;
            }
            if (isStillWatched) continue;
            wiresToRemove.add((Object)wire);
        }
        Networking.sendTo(player, new MessageRemoveWires((Set<Wire>)wiresToRemove));
    }

    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        this.playerToWatchedChunk.put((Object)event.getPlayer().getUUID(), (Object)event.getPos());
        this.watchedChunkToPlayers.put((Object)event.getPos(), (Object)event.getPlayer().getUUID());
        this.sendAddWiresInChunk(event.getPlayer(), event.getPos());
    }

    public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
        this.playerToWatchedChunk.remove((Object)event.getPlayer().getUUID(), (Object)event.getPos());
        this.watchedChunkToPlayers.remove((Object)event.getPos(), (Object)event.getPlayer().getUUID());
        this.sendRemoveWiresInChunk(event.getPlayer(), event.getPos());
    }
}

