/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class DigestionCategory
implements IRecipeCategory<RecipeHolder<DigestionRecipe>> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public DigestionCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(102, 43);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.DIGESTION_VAT.get()));
        this.localizedName = Component.translatable((String)"theurgy.jei.category.digestion");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int overrideAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            int amount = overrideAmount == -1 ? fluidStack.getAmount() : overrideAmount;
            MutableComponent text = Component.translatable((String)"theurgy.misc.unit.millibuckets", (Object[])new Object[]{amount}).withStyle(ChatFormatting.GOLD);
            tooltip.add(text);
        };
    }

    protected IDrawableAnimated getAnimatedArrow(RecipeHolder<DigestionRecipe> recipe) {
        int cookTime = ((DigestionRecipe)recipe.value()).getTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull RecipeHolder<DigestionRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 45, 8);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 45, 8);
        this.drawCookTime(recipe, guiGraphics, 34);
    }

    protected void drawCookTime(RecipeHolder<DigestionRecipe> recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = ((DigestionRecipe)recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            guiGraphics.drawString(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void addToSlot(IRecipeSlotBuilder builder, int ingredientIndex, List<SizedIngredient> ingredients) {
        if (ingredientIndex >= ingredients.size()) {
            return;
        }
        SizedIngredient ingredient = ingredients.get(ingredientIndex);
        builder.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.stream(ingredient.ingredient().getItems()).map(i -> i.copyWithCount(ingredient.count())).toList());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<DigestionRecipe> recipe, @NotNull IFocusGroup focuses) {
        IRecipeSlotBuilder topLeft = builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1);
        IRecipeSlotBuilder topRight = builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1);
        IRecipeSlotBuilder bottomLeft = builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).setBackground(JeiDrawables.INPUT_SLOT, -1, -1);
        this.addToSlot(topLeft, 0, ((DigestionRecipe)recipe.value()).getSizedIngredients());
        this.addToSlot(topRight, 1, ((DigestionRecipe)recipe.value()).getSizedIngredients());
        this.addToSlot(bottomLeft, 2, ((DigestionRecipe)recipe.value()).getSizedIngredients());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 9).setBackground(JeiDrawables.OUTPUT_SLOT, -5, -5).addItemStack(((DigestionRecipe)recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, this.getFluids(recipe))).setFluidRenderer(1000L, false, 16, 16).addTooltipCallback(DigestionCategory.addFluidTooltip(((DigestionRecipe)recipe.value()).getFluidAmount()));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(Arrays.stream(((DigestionRecipe)recipe.value()).getFluid().getFluids()).map(f -> new ItemStack((ItemLike)f.getFluid().getBucket())).toList());
    }

    public List<FluidStack> getFluids(RecipeHolder<DigestionRecipe> recipe) {
        return Arrays.stream(((DigestionRecipe)recipe.value()).getFluid().getFluids()).map(f -> {
            FluidStack stack = f.copy();
            f.setAmount(((DigestionRecipe)recipe.value()).getFluidAmount());
            return stack;
        }).toList();
    }

    @NotNull
    public RecipeType<RecipeHolder<DigestionRecipe>> getRecipeType() {
        return JeiRecipeTypes.DIGESTION;
    }
}

