/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VatRedstoneEntry
extends EntryProvider {
    public static final String ENTRY_ID = "vat_redstone";

    public VatRedstoneEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("redstone_control", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Redstone Control");
        this.add(this.context().pageText(), "Vats can be closed by applying a redstone signal (if a valid recipe is present).\\\nIf a redstone signal is applied and ingredients for a valid recipe are inserted, the vat will automatically close.\\\n\\\n\\\nIf the redstone signal is turned off the vat will open again.\n");
        ((BookImagePageModel)this.page("sides", () -> BookImagePageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()))).withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/redstone_digestion_vat.png"), this.modLoc("textures/gui/book/redstone_fermentation_vat.png")});
        this.add(this.context().pageTitle(), "Sided Behaviour");
        this.add(this.context().pageText(), "The side with the dark red (light red if it outputs a redstone signal) dot is where the vat **outputs** redstone. On all other side it accepts redstone input.\n");
        this.page("redstone_output", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Redstone Output");
        this.add(this.context().pageText(), "Vats output a redstone signal when they have at least one item in the output slot.\n\\\n\\\nThis can be used unlock the vat when it produced a result to extract it.\n");
        this.page("analog_output", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Analog Output");
        this.add(this.context().pageText(), "Vats output a comparator signal based on the amount of items in the output slot.\n\\\n\\\nThis can be used for advanced automation that only unlocks the vat when a certain amount of items is produced.\n");
    }

    protected String entryName() {
        return "Vat Redstone Control";
    }

    protected String entryDescription() {
        return "Redstone input and output for fermentation and digestion vats.";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.REDSTONE_TORCH);
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

