/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.datagen.book.logistics.AttributeFilterEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.ConnectionNodeEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.FluidExtractorEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.FluidInserterEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.FluidListFilterEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.FrequencyEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.IntroEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.ItemExtractorEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.ItemInserterEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.ListFilterEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.LogisticsNetworkEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.LoreEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.MercurialWandEntry;
import com.klikli_dev.theurgy.datagen.book.logistics.MercurialWireEntry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.world.level.ItemLike;

public class LogisticsCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "logistics";

    public LogisticsCategory(TheurgyBookProvider parent) {
        super((ModonomiconProviderBase)parent);
    }

    protected String[] generateEntryMap() {
        return new String[]{"______________________________\u00f4___", "__________________________________", "______________________________\u00ec___", "__________________________________", "________________l___\u00ed_____\u0192___\u00e8___", "__________________________________", "________________i_____\u0175_n_\u0148_______", "__________________________________", "________________w___e_____f_______", "__________________________________", "__________________________a_______", "__________________________________"};
    }

    protected void generateEntries() {
        BookEntryModel introEntry = new IntroEntry(this).generate('i');
        BookEntryModel loreEntry = new LoreEntry(this).generate('l');
        loreEntry.withParent(introEntry);
        BookEntryModel wandEntry = new MercurialWandEntry(this).generate('w');
        wandEntry.withParent(introEntry);
        BookEntryModel wireEntry = new MercurialWireEntry(this).generate('\u0175');
        wireEntry.withParent(introEntry);
        BookEntryModel extractorEntry = new ItemExtractorEntry(this).generate('e');
        extractorEntry.withParent(introEntry);
        BookEntryModel inserterEntry = new ItemInserterEntry(this).generate('\u00ed');
        inserterEntry.withParent(introEntry);
        BookEntryModel networkEntry = new LogisticsNetworkEntry(this).generate('n');
        networkEntry.withParent(wireEntry);
        networkEntry.withParent(extractorEntry);
        networkEntry.withParent(inserterEntry);
        BookEntryModel nodeEntry = new ConnectionNodeEntry(this).generate('\u0148');
        nodeEntry.withParent(networkEntry);
        BookEntryModel listFilterEntry = new ListFilterEntry(this).generate('f');
        listFilterEntry.withParent(nodeEntry);
        BookEntryModel attributeFilterEntry = new AttributeFilterEntry(this).generate('a');
        attributeFilterEntry.withParent(listFilterEntry);
        BookEntryModel frequencyEntry = new FrequencyEntry(this).generate('\u0192');
        frequencyEntry.withParent(nodeEntry);
        BookEntryModel fluidExtractorEntry = new FluidExtractorEntry(this).generate('\u00e8');
        fluidExtractorEntry.withParent(nodeEntry);
        BookEntryModel fluidInserterEntry = new FluidInserterEntry(this).generate('\u00ec');
        fluidInserterEntry.withParent(fluidExtractorEntry);
        BookEntryModel fluidListFilterEntry = new FluidListFilterEntry(this).generate('\u00f4');
        fluidListFilterEntry.withParent(fluidInserterEntry);
    }

    protected String categoryName() {
        return "Mercurial Logistics";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.MERCURIAL_WAND.get()));
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    protected BookCategoryModel additionalSetup(BookCategoryModel category) {
        return super.additionalSetup(category).withBackground(Theurgy.loc("textures/gui/book/bg_nightsky4_small.png"));
    }
}

