/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mode;

import com.klikli_dev.theurgy.content.item.mode.ItemModeRenderHandler;
import com.klikli_dev.theurgy.content.render.itemhud.ItemHUDProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ItemMode
implements ItemHUDProvider {
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean onLeftClickBlock(Level level, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        return false;
    }

    public void onLeftClickEmpty(Level level, Player player, InteractionHand hand) {
    }

    public void onScrollWithRightDown(Player player, ItemStack stack, int shift) {
    }

    public boolean supportsScrollWithRightDown() {
        return false;
    }

    protected abstract String typeName();

    public abstract String descriptionId();

    public int hashCode() {
        return this.typeName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemMode && ((ItemMode)obj).typeName().equals(this.typeName());
    }

    public MutableComponent description(ItemStack pStack, @Nullable Level pLevel) {
        return Component.translatable((String)this.descriptionId());
    }

    @Override
    public void appendHUDText(Player pPlayer, HitResult pHitResult, ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents) {
        pTooltipComponents.add((Component)this.description(pStack, pLevel));
    }

    public abstract ItemModeRenderHandler<?> renderHandler();
}

