/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import com.klikli_dev.theurgy.content.render.outliner.Outliner;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowSulfuricFluxEmitterStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SulfuricFluxEmitterInteractionBehaviour
implements InteractionBehaviour {
    @Override
    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof SulfuricFluxEmitterBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        Networking.sendTo((ServerPlayer)pPlayer, new MessageShowSulfuricFluxEmitterStatus(pPos, sulfuricFluxEmitter.sourcePedestals, sulfuricFluxEmitter.targetPedestal, sulfuricFluxEmitter.resultPedestal));
        sulfuricFluxEmitter.checkValidMultiblockOnNextQuery = true;
        return ItemInteractionResult.SUCCESS;
    }

    public void showStatus(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SulfuricFluxEmitterBlockEntity)) {
            return;
        }
        SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
        this.showOutlines(level, sulfuricFluxEmitter);
        this.showStatusMessage(level, player, sulfuricFluxEmitter);
    }

    private void showOutlines(Level level, SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        boolean isValid;
        VoxelShape shape;
        BlockPos pos;
        if (sulfuricFluxEmitter.targetPedestal != null) {
            pos = sulfuricFluxEmitter.targetPedestal.getBlockPos();
            shape = Shapes.block();
            isValid = level.getBlockEntity(sulfuricFluxEmitter.targetPedestal.getBlockPos()) instanceof ReformationTargetPedestalBlockEntity;
            Outliner.get().showAABB(sulfuricFluxEmitter.targetPedestal, shape.bounds().move(pos), 100).colored(isValid ? sulfuricFluxEmitter.targetPedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
        if (sulfuricFluxEmitter.resultPedestal != null) {
            pos = sulfuricFluxEmitter.resultPedestal.getBlockPos();
            shape = Shapes.block();
            isValid = level.getBlockEntity(sulfuricFluxEmitter.resultPedestal.getBlockPos()) instanceof ReformationResultPedestalBlockEntity;
            Outliner.get().showAABB(sulfuricFluxEmitter.resultPedestal, shape.bounds().move(pos), 100).colored(isValid ? sulfuricFluxEmitter.resultPedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
        for (SulfuricFluxEmitterSelectedPoint sourcePedestal : sulfuricFluxEmitter.sourcePedestals) {
            BlockPos pos2 = sourcePedestal.getBlockPos();
            VoxelShape shape2 = Shapes.block();
            boolean isValid2 = level.getBlockEntity(sourcePedestal.getBlockPos()) instanceof ReformationSourcePedestalBlockEntity;
            Outliner.get().showAABB(sourcePedestal, shape2.bounds().move(pos2), 100).colored(isValid2 ? sourcePedestal.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
    }

    private void showStatusMessage(Level level, Player player, SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        if (sulfuricFluxEmitter.sourcePedestalsWithContents.isEmpty() && sulfuricFluxEmitter.targetPedestal == null && sulfuricFluxEmitter.resultPedestal == null) {
            player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection").withStyle(ChatFormatting.RED), true);
        } else {
            boolean hasTarget = sulfuricFluxEmitter.targetPedestal != null && level.getBlockEntity(sulfuricFluxEmitter.targetPedestal.getBlockPos()) instanceof ReformationTargetPedestalBlockEntity;
            boolean hasResult = sulfuricFluxEmitter.resultPedestal != null && level.getBlockEntity(sulfuricFluxEmitter.resultPedestal.getBlockPos()) instanceof ReformationResultPedestalBlockEntity;
            long sources = sulfuricFluxEmitter.sourcePedestals.stream().map(p -> level.getBlockEntity(p.getBlockPos())).filter(e -> e instanceof ReformationSourcePedestalBlockEntity).count();
            if (!hasTarget) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target").withStyle(ChatFormatting.RED), true);
            }
            if (sources <= 0L) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources").withStyle(ChatFormatting.RED), true);
            }
            if (!hasResult) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result").withStyle(ChatFormatting.RED), true);
            }
            if (hasTarget && sources > 0L && hasResult) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter", (Object[])new Object[]{Component.literal((String)String.valueOf(sources)).withStyle(ChatFormatting.DARK_PURPLE), Component.literal((String)String.valueOf(1)).withStyle(ChatFormatting.BLUE), Component.literal((String)String.valueOf(1)).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.WHITE), true);
            }
        }
    }
}

