/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.extractor;

import com.klikli_dev.theurgy.content.behaviour.filter.Filter;
import com.klikli_dev.theurgy.content.behaviour.logistics.ExtractorNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.InsertTarget;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.integration.occultism.OccultismIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class LogisticsItemExtractorBehaviour
extends ExtractorNodeBehaviour<IItemHandler, Direction> {
    public static final int EXTRACTION_EVERY_N_TICKS = 20;
    public static final int MAX_EXTRACTION_AMOUNT = 64;
    private final int slowTickRandomOffset = (int)(Math.random() * 20.0);
    private int extractionAmount = 64;
    private Direction directionOverride = null;
    private boolean enabled = true;

    public LogisticsItemExtractorBehaviour(BlockEntity blockEntity) {
        super(blockEntity, Capabilities.ItemHandler.BLOCK);
    }

    @Override
    protected boolean isValidInsertTarget(LeafNodeBehaviour<IItemHandler, @Nullable Direction> leafNode, BlockCapabilityCache<IItemHandler, @Nullable Direction> capability) {
        return true;
    }

    @Override
    @Nullable
    public Direction getTargetContext(BlockPos targetPos) {
        return this.directionOverride != null ? this.directionOverride : (Direction)this.blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void directionOverride(Direction directionOverride) {
        this.directionOverride = directionOverride;
        this.rebuildExtractTargets();
    }

    public Direction directionOverride() {
        return this.directionOverride;
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("extractionAmount", this.extractionAmount);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("extractionAmount")) {
            this.extractionAmount = pTag.getInt("extractionAmount");
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.writeNetwork(pTag, pRegistries);
        pTag.putBoolean("enabled", this.enabled);
        if (this.directionOverride != null) {
            pTag.putInt("directionOverride", this.directionOverride.get3DDataValue());
        }
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.readNetwork(pTag, pRegistries);
        if (pTag.contains("directionOverride")) {
            this.directionOverride = Direction.from3DDataValue((int)pTag.getInt("directionOverride"));
        }
        if (pTag.contains("enabled")) {
            this.enabled = pTag.getBoolean("enabled");
        }
    }

    @Override
    public void tickServer() {
        if (!this.enabled) {
            return;
        }
        super.tickServer();
        if (((long)this.slowTickRandomOffset + this.blockEntity.getLevel().getGameTime()) % 20L != 0L) {
            return;
        }
        this.distributor.tick();
        InsertTarget insertTarget = this.distributor.target();
        if (insertTarget == null || !insertTarget.inserter().enabled()) {
            return;
        }
        BlockCapabilityCache extractTarget = (BlockCapabilityCache)this.extractTargets.getFirst();
        if (extractTarget == null) {
            return;
        }
        IItemHandler insertCap = (IItemHandler)insertTarget.capability().getCapability();
        if (insertCap == null) {
            return;
        }
        IItemHandler extractCap = (IItemHandler)extractTarget.getCapability();
        if (extractCap == null) {
            return;
        }
        if (OccultismIntegration.get().tryPerformStorageActuatorExtraction(this.level(), extractCap, this.filter(), insertCap, insertTarget.inserter().filter(), this.extractionAmount)) {
            return;
        }
        this.performExtraction(extractCap, this.filter(), insertCap, insertTarget.inserter().filter());
    }

    protected void performExtraction(IItemHandler extractCap, Filter extractFilter, IItemHandler insertCap, Filter insertFilter) {
        Level level = this.level();
        for (int extractSlot = 0; extractSlot < extractCap.getSlots(); ++extractSlot) {
            ItemStack inserted;
            ItemStack extractStack;
            ItemStack stack = extractCap.getStackInSlot(extractSlot);
            if (stack.isEmpty() || !extractFilter.test(level, stack) || !insertFilter.test(level, stack) || (extractStack = extractCap.extractItem(extractSlot, this.extractionAmount, true)).isEmpty() || (inserted = ItemHandlerHelper.insertItemStacked((IItemHandler)insertCap, (ItemStack)extractStack, (boolean)true)).getCount() == extractStack.getCount()) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)insertCap, (ItemStack)extractStack, (boolean)false);
            extractCap.extractItem(extractSlot, extractStack.getCount() - remaining.getCount(), false);
            break;
        }
    }
}

