/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DigestionCraftingBehaviour
extends CraftingBehaviour<ItemHandlerWithFluidRecipeInput, DigestionRecipe, DigestionCachedCheck> {
    protected Supplier<IFluidHandler> fluidTankSupplier;

    public DigestionCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> fluidTankSupplier) {
        super(blockEntity, Lazy.of(() -> new ItemHandlerWithFluidRecipeInput((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)fluidTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new DigestionCachedCheck((RecipeType<DigestionRecipe>)((RecipeType)RecipeTypeRegistry.DIGESTION.get())));
        this.fluidTankSupplier = fluidTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (this.alreadyHasInput(stack)) {
            return true;
        }
        Optional currentRecipe = this.getRecipe();
        if (currentRecipe.isPresent()) {
            return ((DigestionRecipe)currentRecipe.get().value()).getIngredients().stream().anyMatch(ingredient -> ingredient.test(stack));
        }
        List<ItemStack> ingredientsList = Stream.concat(IntStream.range(0, ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots()).filter(i -> !((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i).isEmpty()).mapToObj(i -> ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i)), Stream.of(stack)).toList();
        if (ingredientsList.size() > 1) {
            return ((DigestionCachedCheck)this.recipeCachedCheck).getRecipeFor(ingredientsList, this.blockEntity.getLevel()).isPresent();
        }
        return this.isIngredient(stack);
    }

    public void onInputChanged() {
        ((DigestionCachedCheck)this.recipeCachedCheck).resetNoRecipeForLastItemHandlerInput();
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return ((DigestionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    public boolean canProcess(FluidStack stack) {
        if (FluidStack.isSameFluidSameComponents((FluidStack)this.fluidTankSupplier.get().getFluidInTank(0), (FluidStack)stack)) {
            return true;
        }
        return this.isIngredient(stack);
    }

    @Override
    public boolean isIngredient(FluidStack stack) {
        return ((DigestionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    protected int getIngredientCount(RecipeHolder<DigestionRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<DigestionRecipe> recipe) {
        return ((DigestionRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 200;
    }

    @Override
    protected boolean craft(RecipeHolder<DigestionRecipe> pRecipe) {
        ItemStack assembledStack = ((DigestionRecipe)pRecipe.value()).assemble((ItemHandlerWithFluidRecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)Objects.requireNonNull(this.blockEntity.getLevel()).registryAccess());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        block0: for (SizedIngredient ingredient : ((DigestionRecipe)pRecipe.value()).getSizedIngredients()) {
            for (int i = 0; i < ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots(); ++i) {
                if (!ingredient.ingredient().test(((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i))) continue;
                ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(i, ingredient.count(), false);
                continue block0;
            }
        }
        this.fluidTankSupplier.get().drain(((DigestionRecipe)pRecipe.value()).getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

