/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge.inventory.power;

import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class NeoPolyEnergyWrapper
implements IPolyEnergyStorageItem {
    private final IEnergyStorage storage;
    private ItemStack container = ItemStack.EMPTY;

    public NeoPolyEnergyWrapper(IEnergyStorage storage) {
        this.storage = storage;
    }

    public NeoPolyEnergyWrapper(IEnergyStorage storage, ItemStack container) {
        this.storage = storage;
        this.container = container;
    }

    @Override
    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        return this.storage.receiveEnergy((int)Math.min(maxReceive, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        return this.storage.extractEnergy((int)Math.min(maxExtract, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canExtract() {
        return this.storage.canExtract();
    }

    @Override
    public boolean canReceive() {
        return this.storage.canReceive();
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if ((amount = Math.min(Math.max(amount, Integer.MIN_VALUE), Integer.MAX_VALUE)) > 0L) {
            return this.receiveEnergy((int)amount, false);
        }
        return this.extractEnergy((int)(-amount), false);
    }
}

