/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.creeperhost.polylib.io.sentry.IUnknownPropertiesConsumer;
import net.creeperhost.polylib.io.sentry.protocol.SentryPackage;
import net.creeperhost.polylib.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkVersion
implements IUnknownPropertiesConsumer {
    @NotNull
    private String name;
    @NotNull
    private String version;
    @Nullable
    private List<SentryPackage> packages;
    @Nullable
    private List<String> integrations;
    @Nullable
    private Map<String, Object> unknown;

    public SdkVersion(@NotNull String name, @NotNull String version) {
        this.name = Objects.requireNonNull(name, "name is required.");
        this.version = Objects.requireNonNull(version, "version is required.");
    }

    @Deprecated
    public SdkVersion() {
        this("", "");
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        this.version = Objects.requireNonNull(version, "version is required.");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "name is required.");
    }

    public void addPackage(@NotNull String name, @NotNull String version) {
        Objects.requireNonNull(name, "name is required.");
        Objects.requireNonNull(version, "version is required.");
        SentryPackage newPackage = new SentryPackage(name, version);
        if (this.packages == null) {
            this.packages = new ArrayList<SentryPackage>();
        }
        this.packages.add(newPackage);
    }

    public void addIntegration(@NotNull String integration) {
        Objects.requireNonNull(integration, "integration is required.");
        if (this.integrations == null) {
            this.integrations = new ArrayList<String>();
        }
        this.integrations.add(integration);
    }

    @Override
    @ApiStatus.Internal
    public void acceptUnknownProperties(@NotNull Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Nullable
    public List<SentryPackage> getPackages() {
        return this.packages;
    }

    @Nullable
    public List<String> getIntegrations() {
        return this.integrations;
    }

    @NotNull
    public static SdkVersion updateSdkVersion(@Nullable SdkVersion sdk, @NotNull String name, @NotNull String version) {
        Objects.requireNonNull(name, "name is required.");
        Objects.requireNonNull(version, "version is required.");
        if (sdk == null) {
            sdk = new SdkVersion(name, version);
        } else {
            sdk.setName(name);
            sdk.setVersion(version);
        }
        return sdk;
    }
}

