/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import com.google.common.collect.ImmutableList;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.world.level.ZombieResurrection;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SeismicWave
extends BlockPos {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 64;
    private final boolean first;
    private final boolean affectsTerrain;

    public SeismicWave(int x, int y, int z, boolean first, boolean affectsTerrain) {
        super(x, y, z);
        this.first = first;
        this.affectsTerrain = affectsTerrain;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean affectsTerrain() {
        return this.affectsTerrain;
    }

    public static void createWaves(Level world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        int firstY = ZombieResurrection.getSuitableGround(world, x1, y, z1, 3, false);
        SeismicWave wave = new SeismicWave(x1, y, z1, true, true);
        if (firstY != -1) {
            wave = new SeismicWave(x1, firstY, z1, true, true);
        }
        list.add(wave);
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        }
    }

    @Nullable
    public static SeismicWave addWave(Level world, List<SeismicWave> list, int x, int y, int z) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1) {
            wave = new SeismicWave(x, y, z, false, true);
            list.add(wave);
        }
        if (world.random.nextInt(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false, false));
        }
        return wave;
    }

    public void affectBlocks(Level level, Entity entity) {
        if (this.affectsTerrain) {
            Player playerEntity;
            BlockPos posAbove = this.above();
            BlockState blockstate = level.getBlockState((BlockPos)this);
            Block block = blockstate.getBlock();
            Player player = playerEntity = entity instanceof Player ? (Player)entity : null;
            if (playerEntity != null && playerEntity.mayBuild() || level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                if (blockstate.is(Blocks.GRASS_BLOCK) || blockstate.is(Blocks.DIRT_PATH) || blockstate.is(Blocks.FARMLAND) || blockstate.is(Blocks.PODZOL) || blockstate.is(Blocks.MYCELIUM)) {
                    level.setBlockAndUpdate((BlockPos)this, Blocks.DIRT.defaultBlockState());
                }
                BlockState blockstateAbove = level.getBlockState(posAbove);
                float hardness = blockstateAbove.getDestroySpeed((BlockGetter)level, posAbove);
                if (blockstateAbove.getCollisionShape((BlockGetter)level, posAbove).isEmpty() && hardness > -1.0f && hardness <= 1.0f) {
                    level.destroyBlock(posAbove, playerEntity != null);
                }
                if (block instanceof DoorBlock) {
                    if (DoorBlock.isWoodenDoor((BlockState)blockstate)) {
                        level.levelEvent(1019, (BlockPos)this, 0);
                    } else {
                        level.levelEvent(1020, (BlockPos)this, 0);
                    }
                }
                if (block instanceof TntBlock) {
                    CommonAbstractions.INSTANCE.onBlockCaughtFire(block, blockstate, level, this, null, (LivingEntity)playerEntity);
                    level.removeBlock((BlockPos)this, false);
                }
            }
            if (block instanceof BellBlock) {
                ((BellBlock)block).onHit(level, blockstate, new BlockHitResult(Vec3.atLowerCornerOf((Vec3i)this), entity.getDirection(), (BlockPos)this, false), playerEntity, true);
            }
            if (blockstate.is(Blocks.REDSTONE_ORE)) {
                block.stepOn(level, (BlockPos)this, blockstate, entity);
            }
            if (blockstate.getFluidState().isEmpty()) {
                level.levelEvent(2001, posAbove, Block.getId((BlockState)blockstate));
            } else {
                PlayerSet playerSet = PlayerSet.nearPosition(null, (double)((double)this.getX() + 0.5), (double)this.getY(), (double)((double)this.getZ() + 0.5), (double)1024.0, (ServerLevel)((ServerLevel)entity.level()));
                MutantMonsters.NETWORK.sendMessage(playerSet, new S2CSeismicWaveFluidParticlesMessage(this).toClientboundMessage());
            }
        }
    }

    public static void addAll(Player player, Collection<SeismicWave> seismicWaves) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.get((Object)player));
        builder.addAll(seismicWaves);
        ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.set((Object)player, (Object)builder.build());
    }

    public static SeismicWave poll(Player player) {
        List seismicWaves = (List)ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.get((Object)player);
        if (seismicWaves.size() > 64) {
            seismicWaves = seismicWaves.subList(seismicWaves.size() - 64, seismicWaves.size());
        }
        if (!seismicWaves.isEmpty()) {
            SeismicWave seismicWave = (SeismicWave)((Object)seismicWaves.getFirst());
            seismicWaves = seismicWaves.subList(1, seismicWaves.size());
            ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.set((Object)player, (Object)ImmutableList.copyOf(seismicWaves));
            return seismicWave;
        }
        return null;
    }
}

