/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantEnderman
extends AbstractMutantMonster
implements NeutralMob,
AnimatedEntity {
    private static final ResourceLocation STEP_HEIGHT_MODIFIER_CLONING_ID = MutantMonsters.id("cloning");
    private static final AttributeModifier STEP_HEIGHT_MODIFIER_CLONING = new AttributeModifier(STEP_HEIGHT_MODIFIER_CLONING_ID, -0.4, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Optional<BlockPos>> TELEPORT_POSITION = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Byte> ACTIVE_ARM = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> CLONE = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityAnimation MELEE_ANIMATION = new EntityAnimation(10);
    public static final EntityAnimation THROW_ANIMATION = new EntityAnimation(14);
    public static final EntityAnimation STARE_ANIMATION = new EntityAnimation(100);
    public static final EntityAnimation TELEPORT_ANIMATION = new EntityAnimation(10);
    public static final EntityAnimation SCREAM_ANIMATION = new EntityAnimation(165);
    public static final EntityAnimation CLONE_ANIMATION = new EntityAnimation(600);
    public static final EntityAnimation TELESMASH_ANIMATION = new EntityAnimation(30);
    public static final EntityAnimation DEATH_ANIMATION = new EntityAnimation(280);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    private int[] heldBlock = new int[4];
    private int[] heldBlockTick = new int[4];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<Entity> capturedEntities;
    private DamageSource deathCause;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;
    @Nullable
    private ResourceKey<LootTable> lootTableOverride;

    public MutantEnderman(EntityType<? extends MutantEnderman> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 40;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new ThrowBlockGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StareGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TeleportGoal(this));
        this.goalSelector.addGoal(1, (Goal)new ScreamGoal(this));
        this.goalSelector.addGoal(1, (Goal)new CloneGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TeleSmashGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(15));
        this.goalSelector.addGoal(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new FindTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantEnderman.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.FOLLOW_RANGE, 96.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.4);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TELEPORT_POSITION, Optional.empty());
        builder.define(ACTIVE_ARM, (Object)0);
        builder.define(CLONE, (Object)false);
    }

    public Optional<BlockPos> getTeleportPosition() {
        return (Optional)this.entityData.get(TELEPORT_POSITION);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.entityData.set(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getHeldBlock(int index) {
        return this.heldBlock[index];
    }

    public void setHeldBlock(int index, int blockId, int tick) {
        this.heldBlock[index] = blockId;
        this.heldBlockTick[index] = tick;
        if (!this.level().isClientSide) {
            MutantMonsters.NETWORK.sendMessage(PlayerSet.nearEntity((Entity)this), new S2CMutantEndermanHeldBlockMessage(this, blockId, index).toClientboundMessage());
        }
    }

    public int getHeldBlockTick(int arm) {
        return this.heldBlockTick[arm];
    }

    public int getActiveArm() {
        return ((Byte)this.entityData.get(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.entityData.set(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.entityData.get(CLONE);
    }

    private void setClone(boolean isClone) {
        this.entityData.set(CLONE, (Object)isClone);
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_MORPH_SOUND_EVENT.value(), 2.0f, this.getVoicePitch());
        this.level().broadcastEntityEvent((Entity)this, (byte)0);
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isClone()) {
            return ((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).getDimensions();
        }
        return super.getDefaultDimensions(pose);
    }

    protected float tickHeadTurn(float renderYawOffset, float distance) {
        return this.deathTime > 0 ? distance : super.tickHeadTurn(renderYawOffset, distance);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxFallDistance() {
        return this.isClone() ? 3 : super.getMaxFallDistance();
    }

    public boolean isPickable() {
        return super.isPickable() && this.animation != TELEPORT_ANIMATION;
    }

    protected void updateNoActionTime() {
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (CLONE.equals(key)) {
            this.refreshDimensions();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition().isPresent() && this.level().isClientSide) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnTeleportParticles();
        }
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        super.setTarget(entitylivingbaseIn);
        this.setAggressive(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.isAggressive()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.level().isClientSide) {
            boolean mobGriefing = CommonAbstractions.INSTANCE.getMobGriefingRule(this.level(), (Entity)this);
            for (int i = 0; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0 || this.heldBlockTick[i] != 0) continue;
                BlockPos startPos = BlockPos.containing((double)(this.getX() - 1.5 + this.random.nextDouble() * 4.0), (double)(this.getY() - 0.5 + this.random.nextDouble() * 2.5), (double)(this.getZ() - 1.5 + this.random.nextDouble() * 4.0));
                BlockState heldState = Block.updateFromNeighbourShapes((BlockState)Block.stateById((int)this.heldBlock[i]), (LevelAccessor)this.level(), (BlockPos)startPos);
                if (mobGriefing && this.canPlaceBlock(this.level(), startPos, heldState, startPos.below())) {
                    this.level().setBlockAndUpdate(startPos, heldState);
                    SoundType soundType = heldState.getSoundType();
                    this.level().playSound(null, startPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                    this.setHeldBlock(i, 0, 0);
                    continue;
                }
                if (mobGriefing && this.random.nextInt(50) != 0) continue;
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private boolean canPlaceBlock(Level level, BlockPos startPos, BlockState heldState, BlockPos belowPos) {
        return level.isEmptyBlock(startPos) && !level.isEmptyBlock(belowPos) && level.getBlockState(belowPos).isCollisionShapeFullBlock((BlockGetter)level, belowPos) && heldState.canSurvive((LevelReader)level, startPos) && level.getEntities((Entity)this, new AABB(startPos)).isEmpty();
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET);
            } else {
                Iterator<Entity> iterator = this.capturedEntities.iterator();
                while (iterator.hasNext()) {
                    Entity entity = iterator.next();
                    if (!(this.distanceToSqr(entity) > 400.0) && !entity.isSpectator()) {
                        entity.setXRot(entity.getXRot() + (this.random.nextFloat() - 0.3f) * 6.0f);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            this.spawnTeleportParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public void aiStep() {
        this.jumping = false;
        super.aiStep();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.deathTime = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.level().isClientSide && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() + (double)(this.deathTime > 0 ? 1.0f : 0.0f) - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.getTarget() != null && !this.isAnimationPlaying()) {
            if (this.blockFrenzy == 0 && (this.getLastDamageSource() != null && !this.getLastDamageSource().isDirect() || this.random.nextInt(!this.isPathFinding() ? 300 : 600) == 0)) {
                this.blockFrenzy = 200 + this.random.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.random.nextInt(8) == 0) {
                int index = this.getFavorableHand();
                BlockPos pos = BlockPos.containing((double)(this.getX() - 2.5 + this.random.nextDouble() * 5.0), (double)(this.getY() - 0.5 + this.random.nextDouble() * 3.0), (double)(this.getZ() - 2.5 + this.random.nextDouble() * 5.0));
                BlockState blockState = this.level().getBlockState(pos);
                if (index != -1 && MutantEnderman.canBlockBeHeld(this.level(), pos, blockState, ModRegistry.MUTANT_ENDERMAN_HOLDABLE_IMMUNE_BLOCK_TAG)) {
                    this.setHeldBlock(index, Block.getId((BlockState)blockState), 0);
                    if (CommonAbstractions.INSTANCE.getMobGriefingRule(this.level(), (Entity)this)) {
                        this.level().removeBlock(pos, false);
                    }
                }
            }
        }
    }

    public static boolean canBlockBeHeld(Level level, BlockPos pos, BlockState state, TagKey<Block> tag) {
        return state.isCollisionShapeFullBlock((BlockGetter)level, pos) && !state.hasBlockEntity() && (state.is(Blocks.END_STONE) || !state.is(tag));
    }

    private void updateTeleport() {
        LivingEntity entity = this.getTarget();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.isInWater() || this.fallDistance > 3.0f || entity != null && (this.isPassengerOfSameVehicle((Entity)entity) || this.distanceToSqr((Entity)entity) > 1024.0 || !this.isPathFinding())) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void customServerAiStep() {
        this.updatePersistentAnger((ServerLevel)this.level(), true);
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.random.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.random.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.random.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.random.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.random.nextInt(outer.size()));
    }

    public boolean doHurtTarget(Entity target) {
        if (!this.level().isClientSide && !this.isAnimationPlaying()) {
            int arm = this.getAvailableHand();
            if (!this.teleportByChance(6, target)) {
                if (arm != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[0] == 0 && this.heldBlock[1] == 0;
                    if (allHandsFree && target.getType() != EntityType.WITHER && this.random.nextInt(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.random.nextInt(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(arm);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
            boolean hurt = target.hurt(damageSource, (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            if (!this.level().isClientSide && this.random.nextInt(2) == 0) {
                double x = target.getX() + (this.random.nextDouble() - 0.5) * 24.0;
                double y = target.getY() + (double)this.random.nextInt(5) + 4.0;
                double z = target.getZ() + (this.random.nextDouble() - 0.5) * 24.0;
                this.teleportToPosition(x, y, z);
            }
            if (hurt) {
                this.heal(2.0f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
                }
            }
            this.swing(InteractionHand.MAIN_HAND);
            return hurt;
        }
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!(source.getEntity() instanceof EnderDragon) && !(source.getEntity() instanceof MutantEnderman)) {
            if (!(this.animation != TELEPORT_ANIMATION && this.animation != SCREAM_ANIMATION || source.is(DamageTypes.FELL_OUT_OF_WORLD))) {
                return false;
            }
            boolean hurt = super.hurt(source, amount);
            if (hurt && this.animation == STARE_ANIMATION) {
                this.animation = EntityAnimation.NONE;
                return hurt;
            }
            if (!this.isAnimationPlaying() && this.isAlive()) {
                boolean isImmune;
                Entity entity = source.getEntity();
                boolean bl = isImmune = entity == null;
                if (source.is(DamageTypeTags.IS_PROJECTILE) || source.is(DamageTypeTags.IS_EXPLOSION) || source.is(DamageTypes.FALL)) {
                    isImmune = true;
                }
                if (!this.level().isClientSide && this.teleportByChance(isImmune ? 3 : 6, entity) && !source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                    if (entity instanceof LivingEntity) {
                        this.setLastHurtByMob((LivingEntity)entity);
                    }
                    return false;
                }
                if (isImmune) {
                    return false;
                }
                if (!this.level().isClientSide) {
                    isImmune = source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL);
                    this.teleportByChance(isImmune ? 3 : 5, entity);
                }
            }
            return hurt;
        }
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypeTags.IS_PROJECTILE);
    }

    public boolean addEffect(MobEffectInstance effectInstanceIn, @Nullable Entity entity) {
        return !this.isClone() && super.addEffect(effectInstanceIn, entity);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.random.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.getX() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.getY() + (double)this.random.nextInt((int)radius * 2) - radius;
        double z = this.getZ() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.distanceToSqr(entity) < 100.0) {
            x = entity.getX() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.getY() + this.random.nextDouble() * radius;
            z = entity.getZ() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vec3 vec = new Vec3(this.getX() - entity.getX(), this.getY(0.5) - entity.getEyeY(), this.getZ() - entity.getZ());
            vec = vec.normalize();
            x = this.getX() + (this.random.nextDouble() - 0.5) * 8.0 - vec.x * radius;
            y = this.getY() + (double)this.random.nextInt(8) - vec.y * radius;
            z = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0 - vec.z * radius;
        }
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToPosition(double x, double y, double z) {
        if (!this.isEffectiveAi()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((Mob)this, x, y, z);
            if (flag) {
                this.stopRiding();
                if (!this.isSilent()) {
                    this.level().playLocalSound(this.xo, this.yo, this.zo, (SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), this.getSoundSource(), 1.0f, 1.0f, false);
                    this.playSound((SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.isAnimationPlaying()) {
            return false;
        }
        this.animation = TELEPORT_ANIMATION;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean success = false;
        if (this.level().isLoaded((BlockPos)pos)) {
            do {
                pos.move(Direction.DOWN);
            } while (pos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)pos).blocksMotion());
            pos.move(Direction.UP);
            AABB aabb = this.getType().getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (this.level().noCollision((Entity)this, aabb) && !this.level().containsAnyLiquid(aabb)) {
                success = true;
            }
        }
        if (!success) {
            this.animation = EntityAnimation.NONE;
            return false;
        }
        this.setTeleportPosition((BlockPos)pos);
        return true;
    }

    public static void teleportAttack(LivingEntity attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.getRandom().nextInt(60);
        DamageSource damageSource = attacker.damageSources().mobAttack(attacker);
        if (attacker instanceof Player) {
            radius = 2.0;
            duration = 100;
            damageSource = attacker.damageSources().playerAttack((Player)attacker);
        }
        for (Entity entity : attacker.level().getEntities((Entity)attacker, attacker.getBoundingBox().inflate(radius), EndersoulFragment.IS_VALID_TARGET)) {
            if (entity instanceof LivingEntity && entity.hurt(damageSource, 4.0f) && attacker.getRandom().nextInt(3) == 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, duration));
            }
            double x = entity.getX() - attacker.getX();
            double z = entity.getZ() - attacker.getZ();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            entity.setDeltaMovement((radius * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (radius * signZ * 2.0 - z) * (double)0.2f);
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
    }

    private void spawnTeleportParticles() {
        BlockPos teleportPos = this.getTeleportPosition().orElse(null);
        int amount = teleportPos != null ? 512 : 256;
        for (int i = 0; i < amount; ++i) {
            boolean useCurrentPos = teleportPos == null || i < amount / 2;
            double tempX = (useCurrentPos ? this.getX() : (double)teleportPos.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double tempY = (useCurrentPos ? this.getY() : (double)teleportPos.getY()) + (this.random.nextDouble() - 0.5) * (double)this.getBbHeight() + 1.5;
            double tempZ = (useCurrentPos ? this.getZ() : (double)teleportPos.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            this.level().addParticle((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), tempX, tempY, tempZ, (this.random.nextDouble() - 0.5) * 1.8, (this.random.nextDouble() - 0.5) * 1.8, (this.random.nextDouble() - 0.5) * 1.8);
        }
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(3.0);
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByShield(LivingEntity livingEntity) {
        if (this.isClone()) {
            super.blockedByShield(livingEntity);
        } else {
            livingEntity.hurtMarked = true;
        }
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.capturedEntities = null;
        if (!this.level().isClientSide) {
            this.deathCause = damageSource;
            for (WrappedGoal goal : this.goalSelector.getAvailableGoals()) {
                if (!goal.isRunning()) continue;
                goal.stop();
            }
            AnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.lastHurtByPlayerTime > 0) {
                this.lastHurtByPlayerTime += DEATH_ANIMATION.duration();
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
    }

    protected void tickDeath() {
        Level level;
        this.setDeltaMovement(0.0, Math.min(this.getDeltaMovement().y, 0.0), 0.0);
        if (this.deathTime == 80) {
            this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH_SOUND_EVENT.value(), 5.0f, this.getVoicePitch());
        }
        if (this.deathTime >= 60) {
            if (this.deathTime < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(10.0, 8.0, 10.0), EndersoulFragment.IS_VALID_TARGET);
            }
            if (!this.level().isClientSide && this.random.nextInt(3) != 0) {
                EndersoulFragment orb = new EndersoulFragment(this.level(), this);
                orb.setPos(this.getX(), this.getY() + 3.8, this.getZ());
                orb.setDeltaMovement((this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 1.5);
                this.level().addFreshEntity((Entity)orb);
            }
        }
        if (this.deathTime >= 80 && this.deathTime < DEATH_ANIMATION.duration() - 20 && this.capturedEntities != null) {
            Iterator<Entity> iterator = this.capturedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity.fallDistance > 4.5f) {
                    entity.fallDistance = 4.5f;
                }
                if (!(this.distanceToSqr(entity) > 64.0)) continue;
                if (!EndersoulFragment.isProtected(entity) && !entity.isSpectator()) {
                    double x = this.getX() - entity.getX();
                    double y = entity.getDeltaMovement().y;
                    double z = this.getZ() - entity.getZ();
                    double d = Math.sqrt(x * x + z * z);
                    if (this.getY() + 4.0 > entity.getY()) {
                        y = Math.max(entity.getDeltaMovement().y, (double)0.4f);
                    }
                    entity.setDeltaMovement((double)0.8f * x / d, y, (double)0.8f * z / d);
                    continue;
                }
                iterator.remove();
            }
        }
        if (!this.level().isClientSide && this.deathTime >= 100 && this.deathTime < 150 && this.deathTime % 6 == 0 && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.lootTableOverride = ModRegistry.MUTANT_ENDERMAN_CONTINUOUS_LOOT_TABLE;
            this.dropFromLootTable(this.deathCause != null ? this.deathCause : this.level().damageSources().generic(), this.lastHurtByPlayerTime > 0);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.deathTime >= DEATH_ANIMATION.duration()) {
                super.dropAllDeathLoot(serverLevel, this.deathCause != null ? this.deathCause : this.level().damageSources().generic());
                this.discard();
            }
        }
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.lootTableOverride != null ? this.lootTableOverride : super.getDefaultLootTable();
    }

    protected void dropFromLootTable(DamageSource damageSource, boolean hitByPlayer) {
        super.dropFromLootTable(damageSource, hitByPlayer);
        this.lootTableOverride = null;
    }

    public ItemEntity spawnAtLocation(ItemStack stack) {
        return this.deathTime > 0 ? this.spawnAtLocation(stack, 3.84f) : super.spawnAtLocation(stack);
    }

    public static boolean canSpawn(EntityType<MutantEnderman> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return randomIn.nextInt(3) == 0 && MutantEnderman.checkMonsterSpawnRules(type, (ServerLevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    protected Component getTypeName() {
        return this.isClone() ? ((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).getDescription() : super.getTypeName();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
        compound.putInt("BlockFrenzy", this.blockFrenzy);
        compound.putInt("ScreamDelay", this.screamDelayTick);
        ListTag listNBT = new ListTag();
        for (int i = 0; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] <= 0) continue;
            CompoundTag compoundNBT = NbtUtils.writeBlockState((BlockState)Block.stateById((int)this.heldBlock[i]));
            compound.putByte("Index", (byte)i);
            compoundNBT.putInt("Tick", this.heldBlockTick[i]);
            listNBT.add((Object)compoundNBT);
        }
        if (!listNBT.isEmpty()) {
            compound.put("HeldBlocks", (Tag)listNBT);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.level() instanceof ServerLevel) {
            this.readPersistentAngerSaveData(this.level(), compound);
        }
        this.blockFrenzy = compound.getInt("BlockFrenzy");
        this.screamDelayTick = compound.getInt("ScreamDelay");
        if (compound.contains("HeldBlocks", 9)) {
            ListTag listNBT = compound.getList("HeldBlocks", 9);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundNBT = listNBT.getCompound(i);
                BlockState blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compoundNBT);
                this.setHeldBlock(compoundNBT.getByte("Index"), Block.getId((BlockState)blockState), compound.getInt("Tick"));
            }
        }
        if (this.deathTime > 0) {
            this.animation = DEATH_ANIMATION;
            this.animationTick = this.deathTime;
        }
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    public void playAmbientSound() {
        if (!this.isClone()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.value();
    }

    private boolean isBeingLookedAtBy(LivingEntity target) {
        if (!(target instanceof Mob)) {
            Vec3 lookVec = target.getViewVector(1.0f).normalize();
            Vec3 targetVec = new Vec3(this.getX() - target.getX(), this.getEyeY() - target.getEyeY(), this.getZ() - target.getZ());
            double length = targetVec.length();
            double d = lookVec.dot(targetVec = targetVec.normalize());
            return d > 1.0 - 0.08 / length && target.hasLineOfSight((Entity)this);
        }
        return ((Mob)target).getTarget() == this && target.hasLineOfSight((Entity)this);
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.writeVarInt(this.hasTarget);
        buffer.writeVarInt(this.armScale);
        buffer.writeVarIntArray(this.heldBlock);
        buffer.writeVarIntArray(this.heldBlockTick);
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.hasTarget = additionalData.readVarInt();
        this.armScale = additionalData.readVarInt();
        this.heldBlock = additionalData.readVarIntArray();
        this.heldBlockTick = additionalData.readVarIntArray();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEnderman> {
        public MeleeGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void tick() {
            if (((MutantEnderman)this.mob).animationTick == 3) {
                ((MutantEnderman)this.mob).playSound(SoundEvents.PLAYER_ATTACK_STRONG, 1.0f, ((MutantEnderman)this.mob).getVoicePitch());
                boolean lower = ((MutantEnderman)this.mob).getActiveArm() >= 2;
                float attackDamage = (float)((MutantEnderman)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE);
                for (LivingEntity livingEntity : ((MutantEnderman)this.mob).level().getEntitiesOfClass(LivingEntity.class, ((MutantEnderman)this.mob).getBoundingBox().inflate(4.0))) {
                    if (livingEntity instanceof MutantEnderman || livingEntity instanceof EndersoulClone) continue;
                    double dist = ((MutantEnderman)this.mob).distanceTo((Entity)livingEntity);
                    double x = ((MutantEnderman)this.mob).getX() - livingEntity.getX();
                    double z = ((MutantEnderman)this.mob).getZ() - livingEntity.getZ();
                    if (!(((MutantEnderman)this.mob).getBoundingBox().minY <= livingEntity.getBoundingBox().maxY) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    livingEntity.hurt(((MutantEnderman)this.mob).damageSources().mobAttack((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    livingEntity.setDeltaMovement(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
            }
        }
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEnderman> {
        public ThrowBlockGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean canUse() {
            if (((MutantEnderman)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEnderman)this.mob).triggerThrowBlock && ((MutantEnderman)this.mob).getRandom().nextInt(28) != 0) {
                return false;
            }
            if (((MutantEnderman)this.mob).getTarget() != null && !((MutantEnderman)this.mob).hasLineOfSight((Entity)((MutantEnderman)this.mob).getTarget())) {
                return false;
            }
            int id = ((MutantEnderman)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEnderman)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void start() {
            super.start();
            int id = ((MutantEnderman)this.mob).getActiveArm();
            ((MutantEnderman)this.mob).level().addFreshEntity((Entity)new ThrowableBlock((MutantEnderman)this.mob, id));
            ((MutantEnderman)this.mob).setHeldBlock(id, 0, 0);
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).triggerThrowBlock = false;
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEnderman> {
        private LivingEntity attackTarget;

        public StareGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean canUse() {
            this.attackTarget = ((MutantEnderman)this.mob).getTarget();
            return this.attackTarget != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            ((MutantEnderman)this.mob).ambientSoundTime = -((MutantEnderman)this.mob).getAmbientSoundInterval();
            ((MutantEnderman)this.mob).level().playSound(null, (Entity)this.mob, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE_SOUND_EVENT.value(), ((MutantEnderman)this.mob).getSoundSource(), 2.5f, 0.7f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f);
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.attackTarget.isAlive() && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
            ((MutantEnderman)this.mob).lookControl.setLookAt((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void stop() {
            super.stop();
            this.attackTarget.stopRiding();
            this.attackTarget.hurt(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 2.0f);
            this.attackTarget.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 160 + ((MutantEnderman)this.mob).random.nextInt(140)));
            double x = ((MutantEnderman)this.mob).getX() - this.attackTarget.getX();
            double z = ((MutantEnderman)this.mob).getZ() - this.attackTarget.getZ();
            this.attackTarget.setDeltaMovement(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleportGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void start() {
            ((MutantEnderman)this.mob).animation = TELEPORT_ANIMATION;
            ((MutantEnderman)this.mob).animationTick = 0;
            MutantEnderman.teleportAttack((LivingEntity)this.mob);
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5));
            if (!((MutantEnderman)this.mob).isSilent()) {
                ((MutantEnderman)this.mob).level().playSound(null, ((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.value(), ((MutantEnderman)this.mob).getSoundSource(), 1.0f, 1.0f);
                ((MutantEnderman)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.value(), 1.0f, 1.0f);
            }
            MutantEnderman.teleportAttack((LivingEntity)this.mob);
            ((MutantEnderman)this.mob).setPos(((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo);
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
        }

        @Override
        public void stop() {
            ((MutantEnderman)this.mob).stopRiding();
            ((MutantEnderman)this.mob).fallDistance = 0.0f;
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).teleportTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5));
            super.stop();
            ((MutantEnderman)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEnderman> {
        public ScreamGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean canUse() {
            if (((MutantEnderman)this.mob).getTarget() != null && !((MutantEnderman)this.mob).isAnimationPlaying()) {
                return ((MutantEnderman)this.mob).screamDelayTick <= 0 && ((MutantEnderman)this.mob).distanceToSqr((Entity)((MutantEnderman)this.mob).getTarget()) < 400.0 && ((MutantEnderman)this.mob).random.nextInt(((MutantEnderman)this.mob).isInWaterOrRain() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
            if (((MutantEnderman)this.mob).animationTick == 40) {
                ((MutantEnderman)this.mob).ambientSoundTime = -((MutantEnderman)this.mob).getAmbientSoundInterval();
                ((MutantEnderman)this.mob).level().getLevelData().setRaining(false);
                ((MutantEnderman)this.mob).level().broadcastEntityEvent((Entity)this.mob, (byte)0);
                ((MutantEnderman)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM_SOUND_EVENT.value(), 5.0f, 0.7f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f);
                for (Entity entity : ((MutantEnderman)this.mob).level().getEntities((Entity)this.mob, ((MutantEnderman)this.mob).getBoundingBox().inflate(20.0, 12.0, 20.0), EndersoulFragment.IS_VALID_TARGET)) {
                    if (!(((MutantEnderman)this.mob).distanceToSqr(entity) < 400.0)) continue;
                    entity.hurt(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 4.0f);
                    if (!(entity instanceof Mob)) continue;
                    Mob mobEntity = (Mob)entity;
                    mobEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 3));
                    if (((MutantEnderman)this.mob).random.nextInt(2) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120 + ((MutantEnderman)this.mob).random.nextInt(180), ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(4) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 300 + ((MutantEnderman)this.mob).random.nextInt(300), ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(3) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 120 + ((MutantEnderman)this.mob).random.nextInt(60), 10 + ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(4) == 0) continue;
                    mobEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120 + ((MutantEnderman)this.mob).random.nextInt(400)));
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEnderman> {
        private final List<EndersoulClone> cloneList = new ArrayList<EndersoulClone>();
        private LivingEntity attackTarget;

        public CloneGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean canUse() {
            this.attackTarget = ((MutantEnderman)this.mob).getTarget();
            if (this.attackTarget == null) {
                return false;
            }
            if (this.attackTarget.getType() != EntityType.WITHER && ((MutantEnderman)this.mob).heldBlock[0] == 0 && ((MutantEnderman)this.mob).heldBlock[1] == 0) {
                return ((MutantEnderman)this.mob).hurtTime == 0 && (super.canUse() || !((MutantEnderman)this.mob).isAnimationPlaying() && ((MutantEnderman)this.mob).tickCount % 3 == 0 && ((MutantEnderman)this.mob).random.nextInt(300) == 0);
            }
            return false;
        }

        @Override
        public void start() {
            super.start();
            ((MutantEnderman)this.mob).invulnerableTime = 20;
            AttributeInstance attribute = ((MutantEnderman)this.mob).getAttribute(Attributes.STEP_HEIGHT);
            if (!attribute.hasModifier(STEP_HEIGHT_MODIFIER_CLONING_ID)) {
                attribute.addTransientModifier(STEP_HEIGHT_MODIFIER_CLONING);
            }
            ((MutantEnderman)this.mob).setClone(true);
            ((MutantEnderman)this.mob).clearFire();
            ((MutantEnderman)this.mob).removeAllEffects();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.getX() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
                double y = this.attackTarget.getY() + 8.0;
                double z = this.attackTarget.getZ() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo);
            double x = this.attackTarget.getX() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
            double y = this.attackTarget.getY() + 8.0;
            double z = this.attackTarget.getZ() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
            ((MutantEnderman)this.mob).teleportToPosition(x, y, z);
            EntityUtil.divertAttackers(this.mob, (LivingEntity)this.getRandomClone());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && ((MutantEnderman)this.mob).getTarget() != null && !this.cloneList.isEmpty() && ((MutantEnderman)this.mob).hurtTime == 0;
        }

        public void tick() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulClone clone = this.cloneList.get(i);
                if (clone.isAlive() && clone.level() == ((MutantEnderman)this.mob).level()) continue;
                this.cloneList.remove(i);
            }
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).setClone(false);
            AttributeInstance attribute = ((MutantEnderman)this.mob).getAttribute(Attributes.STEP_HEIGHT);
            attribute.removeModifier(STEP_HEIGHT_MODIFIER_CLONING_ID);
            for (EndersoulClone clone : this.cloneList) {
                if (!clone.isAlive()) continue;
                clone.discard();
                EntityUtil.divertAttackers((Mob)clone, (LivingEntity)this.mob);
            }
            this.cloneList.clear();
            ((MutantEnderman)this.mob).getNavigation().stop();
            this.attackTarget.setLastHurtByMob((LivingEntity)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulClone clone = (EndersoulClone)((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).create(((MutantEnderman)this.mob).level());
            clone.setCloner((MutantEnderman)this.mob);
            this.cloneList.add(clone);
            if (!EntityUtil.teleportTo((Mob)clone, x, y, z)) {
                clone.copyPosition((Entity)this.mob);
            }
            ((MutantEnderman)this.mob).level().addFreshEntity((Entity)clone);
        }

        private Mob getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (Mob)this.cloneList.get(((MutantEnderman)this.mob).random.nextInt(this.cloneList.size()));
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleSmashGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantEnderman)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            LivingEntity target = ((MutantEnderman)this.mob).getTarget();
            if (target != null) {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 5));
                target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 160 + target.getRandom().nextInt(160)));
            }
        }

        public void tick() {
            LivingEntity target = ((MutantEnderman)this.mob).getTarget();
            if (target != null) {
                ((MutantEnderman)this.mob).getNavigation().stop();
                if (((MutantEnderman)this.mob).animationTick < 20) {
                    ((MutantEnderman)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantEnderman)this.mob).animationTick == 17) {
                    target.stopRiding();
                }
                if (((MutantEnderman)this.mob).animationTick == 18) {
                    double x = target.getX() + (target.getRandom().nextDouble() - 0.5) * 14.0;
                    double y = target.getY() + target.getRandom().nextDouble() + (target instanceof Player ? 13.0 : 7.0);
                    double z = target.getZ() + (target.getRandom().nextDouble() - 0.5) * 14.0;
                    EntityUtil.stunRavager(target);
                    EntityUtil.sendParticlePacket((Entity)target, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), 256);
                    target.teleportTo(x, y, z);
                    ((MutantEnderman)this.mob).level().playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, target.getSoundSource(), 1.2f, 0.9f + target.getRandom().nextFloat() * 0.2f);
                    target.hurt(DamageSourcesHelper.source((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 6.0f);
                }
            }
        }
    }

    static class FindTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public FindTargetGoal(MutantEnderman mutantEnderman) {
            super((Mob)mutantEnderman, LivingEntity.class, 10, false, false, target -> (mutantEnderman.isAngryAt((LivingEntity)target) || mutantEnderman.isBeingLookedAtBy((LivingEntity)target) || EndersoulFragment.isProtected((Entity)target)) && target.attackable());
        }

        public boolean canUse() {
            boolean flag;
            boolean bl = flag = !((MutantEnderman)this.mob).isAnimationPlaying() && super.canUse();
            if (flag && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.target)) {
                ((MutantEnderman)this.mob).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            return this.mob.getBoundingBox().inflate(targetDistance, targetDistance / 2.0, targetDistance);
        }
    }
}

