/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantSkeletonBodyPart
extends Entity {
    public static final String TAG_PART = "Part";
    public static final String TAG_DESPAWN_TIMER = "DespawnTimer";
    private static final EntityDataAccessor<Byte> PART = SynchedEntityData.defineId(MutantSkeletonBodyPart.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final boolean yawPositive;
    private final boolean pitchPositive;
    private WeakReference<Mob> owner;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private int despawnTimer;

    public MutantSkeletonBodyPart(EntityType<? extends MutantSkeletonBodyPart> type, Level world) {
        super(type, world);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.yRotO = this.getYRot();
        this.setXRot(this.random.nextFloat() * 360.0f);
        this.xRotO = this.getXRot();
        this.yawPositive = this.random.nextBoolean();
        this.pitchPositive = this.random.nextBoolean();
    }

    public MutantSkeletonBodyPart(Level level, Mob owner, int part) {
        this((EntityType<? extends MutantSkeletonBodyPart>)((EntityType)ModEntityTypes.BODY_PART_ENTITY_TYPE.value()), level);
        this.owner = new WeakReference<Mob>(owner);
        this.setPart(part);
        this.setPos(owner.getX(), owner.getY() + (double)(3.2f * (0.25f + this.random.nextFloat() * 0.5f)), owner.getZ());
        this.setRemainingFireTicks(owner.getRemainingFireTicks());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PART, (Object)0);
    }

    public int getPart() {
        return ((Byte)this.entityData.get(PART)).byteValue();
    }

    private void setPart(int id) {
        this.entityData.set(PART, (Object)((byte)id));
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getLegacyItemByPart());
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.setPos(x, y, z);
        this.setDeltaMovement(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void lerpMotion(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        this.setDeltaMovement(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.045, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.96));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
        }
        if (!this.onGround() && this.stuckSpeedMultiplier == Vec3.ZERO) {
            this.setYRot(this.getYRot() + 10.0f * (float)(this.yawPositive ? 1 : -1));
            this.setXRot(this.getXRot() + 15.0f * (float)(this.pitchPositive ? 1 : -1));
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), this::canHarm)) {
                if (!entity.hurt(this.level().damageSources().thrown((Entity)this, (Entity)(this.owner != null ? (Entity)this.owner.get() : this)), 4.0f + (float)this.random.nextInt(4))) continue;
                entity.igniteForSeconds((float)this.getRemainingFireTicks() / 20.0f);
            }
            if (this.despawnTimer > 0) {
                --this.despawnTimer;
            }
        } else {
            ++this.despawnTimer;
        }
        if (!this.level().isClientSide && this.despawnTimer >= this.getMaxAge()) {
            this.discard();
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ResourceKey<LootTable> resourceKey;
        if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && (resourceKey = this.getItemPartLootTableId()) != null) {
            LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(resourceKey);
            ObjectArrayList list = lootTable.getRandomItems(new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(ModRegistry.BODY_PART_LOOT_CONTEXT_PARAM_SET));
            for (ItemStack item : list) {
                if (item.isEmpty()) continue;
                this.spawnAtLocation(item).setNoPickUpDelay();
            }
        }
        this.discard();
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    private boolean canHarm(Entity entity) {
        return entity.isPickable() && entity.getType() != ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.value();
    }

    protected Component getTypeName() {
        return Component.translatable((String)this.getLegacyItemByPart().getDescriptionId());
    }

    private Item getLegacyItemByPart() {
        int part = this.getPart();
        if (part == 0) {
            return (Item)ModItems.MUTANT_SKELETON_PELVIS_ITEM.value();
        }
        if (part >= 1 && part < 19) {
            return (Item)ModItems.MUTANT_SKELETON_RIB_ITEM.value();
        }
        if (part == 19) {
            return (Item)ModItems.MUTANT_SKELETON_SKULL_ITEM.value();
        }
        if (part >= 21 && part < 29) {
            return (Item)ModItems.MUTANT_SKELETON_LIMB_ITEM.value();
        }
        return part != 29 && part != 30 ? Items.AIR : (Item)ModItems.MUTANT_SKELETON_SHOULDER_PAD_ITEM.value();
    }

    @Nullable
    public ResourceKey<LootTable> getItemPartLootTableId() {
        int part = this.getPart();
        if (part == 0) {
            return ModRegistry.MUTANT_SKELETON_PELVIS_LOOT_TABLE;
        }
        if (part >= 1 && part < 19) {
            return ModRegistry.MUTANT_SKELETON_RIB_LOOT_TABLE;
        }
        if (part == 19) {
            return ModRegistry.MUTANT_SKELETON_SKULL_LOOT_TABLE;
        }
        if (part >= 21 && part < 29) {
            return ModRegistry.MUTANT_SKELETON_LIMB_LOOT_TABLE;
        }
        return part != 29 && part != 30 ? null : ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_LOOT_TABLE;
    }

    public int getMaxAge() {
        return 6000;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putByte(TAG_PART, (byte)this.getPart());
        compound.putShort(TAG_DESPAWN_TIMER, (short)this.despawnTimer);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setPart(compound.getByte(TAG_PART));
        this.despawnTimer = compound.getShort(TAG_DESPAWN_TIMER);
    }
}

