/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.item.ArmorBlockItem;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.Collection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityEventsHandler {
    private static final Ingredient PIG_POISON_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.FERMENTED_SPIDER_EYE});

    public static EventResult onEntityLoad(Entity entity, ServerLevel level) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob creature = (PathfinderMob)entity;
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                creature.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal(creature, MutantCreeper.class, 16.0f, 1.33, 1.33));
            }
            if (creature.getType() == EntityType.PIG) {
                creature.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal(creature, Player.class, 10.0f, 1.25, 1.25, livingEntity -> {
                    Player player;
                    return livingEntity instanceof Player && (PIG_POISON_INGREDIENT.test((player = (Player)livingEntity).getMainHandItem()) || PIG_POISON_INGREDIENT.test(player.getOffhandItem()));
                }));
            }
            if (creature.getType() == EntityType.VILLAGER) {
                creature.goalSelector.addGoal(0, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.8, 0.8));
            }
            if (creature.getType() == EntityType.WANDERING_TRADER) {
                creature.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.5, 0.5));
            }
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack stackInHand;
        Pig pig;
        if (entity instanceof Pig && !(pig = (Pig)entity).hasEffect(MobEffects.UNLUCK) && PIG_POISON_INGREDIENT.test(stackInHand = player.getItemInHand(hand))) {
            if (!player.isCreative()) {
                stackInHand.shrink(1);
            }
            pig.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 600));
            return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        return EventResultHolder.pass();
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        float damage;
        if (entity instanceof Player && entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorBlockItem && !((damage = amount.getAsFloat()) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemStack = entity.getItemBySlot(EquipmentSlot.HEAD);
            if (!source.is(DamageTypeTags.IS_FIRE) || !itemStack.has(DataComponents.FIRE_RESISTANT)) {
                ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)((int)damage), (LivingEntity)entity, (EquipmentSlot)EquipmentSlot.HEAD);
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingDrops(LivingEntity entity, DamageSource damageSource, Collection<ItemEntity> itemDrops, boolean recentlyHit) {
        ItemStack itemStack;
        Entity attacker = damageSource.getEntity();
        if (entity.getType().is(ModRegistry.SPIDER_PIG_TARGETS_ENTITY_TYPE_TAG) && attacker instanceof SpiderPig) {
            return EventResult.INTERRUPT;
        }
        if ((attacker instanceof MutantCreeper && ((MutantCreeper)attacker).isCharged() || attacker instanceof CreeperMinion && ((CreeperMinion)attacker).isCharged()) && damageSource.is(DamageTypeTags.IS_EXPLOSION) && !(itemStack = EntityUtil.getSkullDrop(entity.getType())).isEmpty()) {
            itemDrops.add(new ItemEntity(attacker.level(), entity.getX(), entity.getY(), entity.getZ(), itemStack));
        }
        return EventResult.PASS;
    }
}

