/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantSnowGolemModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class MutantSnowGolemRenderer
extends MobRenderer<MutantSnowGolem, MutantSnowGolemModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_snow_golem/mutant_snow_golem.png");
    public static final ResourceLocation JACK_O_LANTERN_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_snow_golem/jack_o_lantern.png");
    private static final RenderType GLOW_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonsters.id("textures/entity/mutant_snow_golem/glow.png"));

    public MutantSnowGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantSnowGolemModel(context.bakeLayer(ClientModRegistry.MUTANT_SNOW_GOLEM)), 0.7f);
        this.addLayer(new JackOLanternLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.getModelSet()));
        this.addLayer(new HeldBlockLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.getBlockRenderDispatcher()));
    }

    public void render(MutantSnowGolem mutantSnowGolem, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((LivingEntity)mutantSnowGolem, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        Player owner = mutantSnowGolem.getOwner();
        if (owner != null) {
            poseStack.pushPose();
            if (this.shouldShowName((Mob)mutantSnowGolem)) {
                poseStack.translate(0.0, 0.259, 0.0);
            }
            this.renderNameTag((Entity)mutantSnowGolem, (Component)owner.getDisplayName().copy().withStyle(style -> style.withItalic(Boolean.valueOf(true))), poseStack, multiBufferSource, packedLight, partialTick);
            poseStack.popPose();
        }
    }

    public ResourceLocation getTextureLocation(MutantSnowGolem mutantSnowGolem) {
        return TEXTURE_LOCATION;
    }

    static class JackOLanternLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final MutantSnowGolemModel headModel;

        public JackOLanternLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> renderer, EntityModelSet entityModelSet) {
            super(renderer);
            this.headModel = new MutantSnowGolemModel(entityModelSet.bakeLayer(ClientModRegistry.MUTANT_SNOW_GOLEM_HEAD)).setRenderHeadOnly();
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantSnowGolem mutantSnowGolem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mutantSnowGolem.hasJackOLantern()) {
                if (!mutantSnowGolem.isInvisible()) {
                    ((MutantSnowGolemModel)this.getParentModel()).copyPropertiesTo(this.headModel);
                    JackOLanternLayer.renderColoredCutoutModel((EntityModel)this.headModel, (ResourceLocation)JACK_O_LANTERN_TEXTURE_LOCATION, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (LivingEntity)mutantSnowGolem, (int)-1);
                }
                float green = Math.max(0.0f, 0.8f + 0.05f * Mth.cos((float)(ageInTicks * 0.15f)));
                float blue = Math.max(0.0f, 0.15f + 0.2f * Mth.cos((float)(ageInTicks * 0.1f)));
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(GLOW_RENDER_TYPE);
                int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)green, (float)blue);
                ((MutantSnowGolemModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, color);
            }
        }
    }

    static class HeldBlockLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final BlockRenderDispatcher blockRenderer;

        public HeldBlockLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> renderer, BlockRenderDispatcher blockRenderer) {
            super(renderer);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantSnowGolem mutantSnowGolem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mutantSnowGolem.isThrowing() && mutantSnowGolem.getThrowingTick() < 7) {
                poseStack.pushPose();
                boolean leftHanded = mutantSnowGolem.isLeftHanded();
                float scale = Math.min(0.8f, ((float)mutantSnowGolem.getThrowingTick() + partialTick) / 7.0f);
                poseStack.translate(leftHanded ? -0.4 : 0.4, 0.0, 0.0);
                ((MutantSnowGolemModel)this.getParentModel()).translateArm(leftHanded, poseStack);
                poseStack.translate(0.0, 0.9, 0.0);
                poseStack.scale(-scale, -scale, scale);
                poseStack.translate(-0.5, -0.5, 0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                this.blockRenderer.renderSingleBlock(Blocks.ICE.defaultBlockState(), poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
    }
}

