/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.services.ClientAbstractions;
import fuzs.mutantmonsters.services.CommonAbstractions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public abstract class AlternateMobRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public AlternateMobRenderer(EntityRendererProvider.Context context, M entityModelIn, float shadowSizeIn) {
        super(context, entityModelIn, shadowSizeIn);
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        Direction direction;
        float ageInTicks;
        Entity entity2;
        boolean shouldSit;
        if (ClientAbstractions.INSTANCE.onRenderLiving$Pre(entity, this, partialTick, poseStack, multiBufferSource, packedLight)) {
            return;
        }
        poseStack.pushPose();
        this.model.attackTime = this.getAttackAnim((LivingEntity)entity, partialTick);
        this.model.riding = shouldSit = entity.isPassenger() && CommonAbstractions.INSTANCE.shouldRiderSit(entity.getVehicle());
        this.model.young = entity.isBaby();
        float rotationYaw = Mth.rotLerp((float)partialTick, (float)((Mob)entity).yBodyRotO, (float)((Mob)entity).yBodyRot);
        float rotationYawHead = Mth.rotLerp((float)partialTick, (float)((Mob)entity).yHeadRotO, (float)((Mob)entity).yHeadRot);
        float netHeadYaw = rotationYawHead - rotationYaw;
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            rotationYaw = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            netHeadYaw = rotationYawHead - rotationYaw;
            ageInTicks = Mth.wrapDegrees((float)netHeadYaw);
            if (ageInTicks < -85.0f) {
                ageInTicks = -85.0f;
            }
            if (ageInTicks >= 85.0f) {
                ageInTicks = 85.0f;
            }
            rotationYaw = rotationYawHead - ageInTicks;
            if (ageInTicks * ageInTicks > 2500.0f) {
                rotationYaw += ageInTicks * 0.2f;
            }
            netHeadYaw = rotationYawHead - rotationYaw;
        }
        float headPitch = Mth.lerp((float)partialTick, (float)((Mob)entity).xRotO, (float)entity.getXRot());
        if (entity.getPose() == Pose.SLEEPING && (direction = entity.getBedOrientation()) != null) {
            float limbSwingAmount = entity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((double)((float)(-direction.getStepX()) * limbSwingAmount), 0.0, (double)((float)(-direction.getStepZ()) * limbSwingAmount));
        }
        float scale = entity.getScale();
        poseStack.scale(scale, scale, scale);
        ageInTicks = this.getBob((LivingEntity)entity, partialTick);
        this.setupRotations((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTick, scale);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entity, poseStack, partialTick);
        poseStack.translate(0.0, (double)-1.501f, 0.0);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit) {
            limbSwingAmount = ((Mob)entity).walkAnimation.speed(partialTick);
            limbSwing = ((Mob)entity).walkAnimation.position(partialTick);
            if (entity.isBaby()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        Minecraft minecraft = Minecraft.getInstance();
        boolean isVisible = this.isBodyVisible((LivingEntity)entity);
        boolean visibleToSpectator = !isVisible && !entity.isInvisibleTo((Player)minecraft.player);
        boolean isGlowing = minecraft.shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType((LivingEntity)entity, isVisible, visibleToSpectator, isGlowing);
        if (rendertype != null && !this.hasAlternateRender(entity, partialTick, poseStack, multiBufferSource, packedLight)) {
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(rendertype);
            int packedOverlay = OverlayTexture.pack((float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTick), (boolean)this.showsHurtColor(entity));
            float alpha = visibleToSpectator ? 0.15f : this.getAlpha(entity, partialTick);
            int color = FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
        for (RenderLayer layer : this.layers) {
            layer.render(poseStack, multiBufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
        }
        poseStack.popPose();
        ClientAbstractions.INSTANCE.getEntityDisplayName(entity, this, partialTick, poseStack, multiBufferSource, packedLight, this.shouldShowName((Mob)entity)).ifPresent(component -> this.renderNameTag((Entity)entity, (Component)component, poseStack, multiBufferSource, packedLight, partialTick));
        ClientAbstractions.INSTANCE.onRenderLiving$Post(entity, this, partialTick, poseStack, multiBufferSource, packedLight);
    }

    protected boolean hasAlternateRender(T mob, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        return false;
    }

    protected float getAlpha(T mob, float partialTicks) {
        return 1.0f;
    }

    protected boolean showsHurtColor(T mob) {
        return ((Mob)mob).hurtTime > 0;
    }
}

