/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantZombieModel
extends EntityModel<MutantZombie> {
    private final ModelPart pelvis;
    private final ModelPart waist;
    private final ModelPart chest;
    private final ModelPart head;
    private final ModelPart arm1;
    private final ModelPart arm2;
    private final ModelPart forearm1;
    private final ModelPart forearm2;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart foreleg1;
    private final ModelPart foreleg2;
    private float partialTick;

    public MutantZombieModel(ModelPart modelPart) {
        this.pelvis = modelPart.getChild("pelvis");
        this.waist = this.pelvis.getChild("waist");
        this.chest = this.waist.getChild("chest");
        this.head = this.chest.getChild("head");
        this.arm1 = this.chest.getChild("arm1");
        this.arm2 = this.chest.getChild("arm2");
        this.forearm1 = this.arm1.getChild("fore_arm1");
        this.forearm2 = this.arm2.getChild("fore_arm2");
        this.leg1 = this.pelvis.getChild("leg1");
        this.leg2 = this.pelvis.getChild("leg2");
        this.foreleg1 = this.leg1.getChild("fore_leg1");
        this.foreleg2 = this.leg2.getChild("fore_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pelvis = root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)10.0f, (float)6.0f));
        PartDefinition waist = pelvis.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(0, 44).addBox(-7.0f, -16.0f, -6.0f, 14.0f, 16.0f, 12.0f), PartPose.ZERO);
        PartDefinition chest = waist.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 16).addBox(-12.0f, -12.0f, -8.0f, 24.0f, 12.0f, 16.0f), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        chest.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-11.0f, (float)-4.0f));
        PartDefinition arm1 = chest.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(104, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offset((float)-11.0f, (float)-8.0f, (float)2.0f));
        PartDefinition arm2 = chest.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(104, 0).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offset((float)11.0f, (float)-8.0f, (float)2.0f));
        arm1.addOrReplaceChild("fore_arm1", CubeListBuilder.create().texOffs(104, 22).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        arm2.addOrReplaceChild("fore_arm2", CubeListBuilder.create().texOffs(104, 22).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition leg1 = pelvis.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(80, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), PartPose.offset((float)-5.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leg2 = pelvis.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(80, 0).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), PartPose.offset((float)5.0f, (float)-2.0f, (float)0.0f));
        leg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(80, 17).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        leg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(80, 17).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)9.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.pelvis.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(MutantZombie entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.y = 10.0f;
        this.waist.xRot = 0.19634955f;
        this.chest.xRot = 0.5235988f;
        this.chest.yRot = 0.0f;
        this.head.xRot = -0.71994835f;
        this.head.yRot = 0.0f;
        this.head.zRot = 0.0f;
        this.arm1.xRot = -0.32724923f;
        this.arm1.yRot = 0.0f;
        this.arm1.zRot = 0.3926991f;
        this.arm2.xRot = -0.32724923f;
        this.arm2.yRot = 0.0f;
        this.arm2.zRot = -0.3926991f;
        this.forearm1.xRot = -1.0471976f;
        this.forearm2.xRot = -1.0471976f;
        this.leg1.xRot = -0.7853982f;
        this.leg1.yRot = 0.0f;
        this.leg1.zRot = 0.0f;
        this.leg2.xRot = -0.7853982f;
        this.leg2.yRot = 0.0f;
        this.leg2.zRot = 0.0f;
        this.foreleg1.xRot = 0.7853982f;
        this.foreleg2.xRot = 0.7853982f;
    }

    private void animate(MutantZombie zombie, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkAnim1 = (Mth.sin((float)((limbSwing - 0.7f) * 0.4f)) + 0.7f) * limbSwingAmount;
        float walkAnim2 = -(Mth.sin((float)((limbSwing + 0.7f) * 0.4f)) - 0.7f) * limbSwingAmount;
        float walkAnim = Mth.sin((float)(limbSwing * 0.4f)) * limbSwingAmount;
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.1f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (zombie.deathTime <= 0) {
            float scale;
            if (zombie.getAnimation() == MutantZombie.SLAM_GROUND_ANIMATION) {
                this.animateMelee(zombie.getAnimationTick());
            }
            if (zombie.getAnimation() == MutantZombie.ROAR_ANIMATION) {
                this.animateRoar(zombie.getAnimationTick());
                scale = 1.0f - Mth.clamp((float)((float)zombie.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
            if (zombie.getAnimation() == MutantZombie.THROW_ANIMATION) {
                this.animateThrow(zombie);
                scale = 1.0f - Mth.clamp((float)((float)zombie.getAnimationTick() / 3.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
        } else {
            this.animateDeath(zombie);
            float scale = 1.0f - Mth.clamp((float)((float)zombie.deathTime / 6.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim *= scale;
            breatheAnim *= scale;
            faceYaw *= scale;
            facePitch *= scale;
        }
        this.chest.xRot += breatheAnim * 0.02f;
        this.arm1.zRot -= breatheAnim * 0.05f;
        this.arm2.zRot += breatheAnim * 0.05f;
        this.head.xRot += facePitch * 0.6f;
        this.head.yRot += faceYaw * 0.8f;
        this.head.zRot -= faceYaw * 0.2f;
        this.chest.xRot += facePitch * 0.4f;
        this.chest.yRot += faceYaw * 0.2f;
        this.pelvis.y += Mth.sin((float)(limbSwing * 0.8f)) * limbSwingAmount * 0.5f;
        this.chest.yRot -= walkAnim * 0.1f;
        this.arm1.xRot -= walkAnim * 0.6f;
        this.arm2.xRot += walkAnim * 0.6f;
        this.leg1.xRot += walkAnim1 * 0.9f;
        this.leg2.xRot += walkAnim2 * 0.9f;
    }

    private void animateMelee(int fullTick) {
        this.arm1.zRot = 0.0f;
        this.arm2.zRot = 0.0f;
        if (fullTick < 8) {
            float tick = ((float)fullTick + this.partialTick) / 8.0f;
            float f = -Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.2f;
            this.arm1.xRot += f * 2.3f;
            this.arm1.zRot += f1 * (float)Math.PI / 8.0f;
            this.arm2.xRot += f * 2.3f;
            this.arm2.zRot -= f1 * (float)Math.PI / 8.0f;
            this.forearm1.xRot += f * 0.8f;
            this.forearm2.xRot += f * 0.8f;
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 4.0f;
            float f = -Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.9f + 0.7f;
            this.chest.xRot += f * 0.9f + 0.7f;
            this.arm1.xRot += f * 0.2f - 2.1f;
            this.arm1.zRot += f1 * 0.3f;
            this.arm2.xRot += f * 0.2f - 2.1f;
            this.arm2.zRot -= f1 * 0.3f;
            this.forearm1.xRot += f + 0.2f;
            this.forearm2.xRot += f + 0.2f;
        } else if (fullTick < 16) {
            this.waist.xRot += 0.7f;
            this.chest.xRot += 0.7f;
            this.arm1.xRot -= 2.1f;
            this.arm1.zRot += 0.3f;
            this.arm2.xRot -= 2.1f;
            this.arm2.zRot -= 0.3f;
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
        } else if (fullTick < 24) {
            float tick = ((float)(fullTick - 16) + this.partialTick) / 8.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.7f;
            this.chest.xRot += f * 0.7f;
            this.arm1.xRot -= f * 2.1f;
            this.arm1.zRot += f * -0.09269908f + 0.3926991f;
            this.arm2.xRot -= f * 2.1f;
            this.arm2.zRot -= f * -0.09269908f + 0.3926991f;
            this.forearm1.xRot += f * 0.2f;
            this.forearm2.xRot += f * 0.2f;
        } else {
            this.arm1.zRot += 0.3926991f;
            this.arm2.zRot += -0.3926991f;
        }
    }

    private void animateRoar(int fullTick) {
        float f1;
        float f;
        float tick;
        if (fullTick < 10) {
            tick = ((float)fullTick + this.partialTick) / 10.0f;
            f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI * (float)Math.PI / 8.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.4f;
            this.chest.yRot += f1 * 0.06f;
            this.head.xRot += f * 0.8f;
            this.arm1.xRot -= f * 1.2f;
            this.arm1.zRot += f * 0.6f;
            this.arm2.xRot -= f * 1.2f;
            this.arm2.zRot -= f * 0.6f;
            this.forearm1.xRot -= f * 0.8f;
            this.forearm2.xRot -= f * 0.8f;
        } else if (fullTick < 15) {
            tick = ((float)(fullTick - 10) + this.partialTick) / 5.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.39634955f - 0.19634955f;
            this.chest.xRot += f * 0.6f - 0.2f;
            this.head.xRot += f - 0.2f;
            this.arm1.xRot -= f * 2.2f - 1.0f;
            this.arm1.yRot += f1 * 0.4f;
            this.arm1.zRot += 0.6f;
            this.arm2.xRot -= f * 2.2f - 1.0f;
            this.arm2.yRot -= f1 * 0.4f;
            this.arm2.zRot -= 0.6f;
            this.forearm1.xRot -= f - 0.2f;
            this.forearm2.xRot -= f - 0.2f;
            this.leg1.yRot += f1 * 0.3f;
            this.leg2.yRot -= f1 * 0.3f;
        } else if (fullTick < 75) {
            this.waist.xRot -= 0.19634955f;
            this.chest.xRot -= 0.2f;
            this.head.xRot -= 0.2f;
            Animator.addRotationAngle(this.arm1, 1.0f, 0.4f, 0.6f);
            Animator.addRotationAngle(this.arm2, 1.0f, -0.4f, -0.6f);
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
            this.leg1.yRot += 0.3f;
            this.leg2.yRot -= 0.3f;
        } else if (fullTick < 90) {
            tick = ((float)(fullTick - 75) + this.partialTick) / 15.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot -= f * 0.69634956f - 0.5f;
            this.chest.xRot -= f * 0.7f - 0.5f;
            this.head.xRot -= f * 0.6f - 0.4f;
            Animator.addRotationAngle(this.arm1, f * 2.6f - 1.6f, f * 0.4f, f * 0.99269915f - 0.3926991f);
            Animator.addRotationAngle(this.arm2, f * 2.6f - 1.6f, -f * 0.4f, -f * 0.99269915f + 0.3926991f);
            this.forearm1.xRot += f * -0.6f + 0.8f;
            this.forearm2.xRot += f * -0.6f + 0.8f;
            this.leg1.yRot += f * 0.3f;
            this.leg2.yRot -= f * 0.3f;
        } else if (fullTick < 110) {
            this.waist.xRot += 0.5f;
            this.chest.xRot += 0.5f;
            this.head.xRot += 0.4f;
            Animator.addRotationAngle(this.arm1, -1.6f, 0.0f, -0.3926991f);
            Animator.addRotationAngle(this.arm2, -1.6f, 0.0f, 0.3926991f);
            this.forearm1.xRot += 0.8f;
            this.forearm2.xRot += 0.8f;
        } else {
            tick = ((float)(fullTick - 110) + this.partialTick) / 10.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.5f;
            this.chest.xRot += f * 0.5f;
            this.head.xRot += f * 0.4f;
            Animator.addRotationAngle(this.arm1, f * -1.6f, 0.0f, f * (float)(-Math.PI) / 8.0f);
            Animator.addRotationAngle(this.arm2, f * -1.6f, 0.0f, f * (float)Math.PI / 8.0f);
            this.forearm1.xRot += f * 0.8f;
            this.forearm2.xRot += f * 0.8f;
        }
        if (fullTick >= 10 && fullTick < 75) {
            tick = ((float)(fullTick - 10) + this.partialTick) / 65.0f;
            f = Mth.sin((float)(tick * (float)Math.PI * 8.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI * 8.0f + 0.7853982f));
            this.head.yRot += f * 0.5f - f1 * 0.2f;
            this.head.zRot -= f * 0.5f;
            this.chest.yRot += f1 * 0.06f;
        }
    }

    private void animateThrow(MutantZombie zombie) {
        if (zombie.getAnimationTick() < 3) {
            float tick = ((float)zombie.getAnimationTick() + this.partialTick) / 3.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.chest.xRot -= f * 0.4f;
            this.arm1.xRot -= f * 1.8f;
            this.arm1.zRot -= f * (float)Math.PI / 8.0f;
            this.arm2.xRot -= f * 1.8f;
            this.arm2.zRot += f * (float)Math.PI / 8.0f;
        } else if (zombie.getAnimationTick() < 5) {
            this.chest.xRot -= 0.4f;
            this.arm1.xRot -= 1.0f;
            this.arm1.zRot = 0.0f;
            this.arm2.xRot -= 1.0f;
            this.arm2.zRot = 0.0f;
        } else if (zombie.getAnimationTick() < 8) {
            float tick = ((float)(zombie.getAnimationTick() - 5) + this.partialTick) / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f1 * 0.2f;
            this.chest.xRot -= f * 0.6f - 0.2f;
            this.arm1.xRot -= f * 2.2f - 0.4f;
            this.arm1.zRot -= f * (float)Math.PI / 8.0f;
            this.arm2.xRot -= f * 2.2f - 0.4f;
            this.arm2.zRot += f * (float)Math.PI / 8.0f;
            this.forearm1.xRot -= f1 * 0.4f;
            this.forearm2.xRot -= f1 * 0.4f;
        } else if (zombie.getAnimationTick() < 10) {
            this.waist.xRot += 0.2f;
            this.chest.xRot += 0.2f;
            this.arm1.xRot += 0.4f;
            this.arm2.xRot += 0.4f;
            this.forearm1.xRot -= 0.4f;
            this.forearm2.xRot -= 0.4f;
        } else if (zombie.getAnimationTick() < 15) {
            float tick = ((float)(zombie.getAnimationTick() - 10) + this.partialTick) / 5.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.39634955f - 0.19634955f;
            this.chest.xRot += f * 0.8f - 0.6f;
            this.arm1.xRot += f * 3.0f - 2.6f;
            this.arm2.xRot += f * 3.0f - 2.6f;
            this.forearm1.xRot -= f * 0.4f;
            this.forearm2.xRot -= f * 0.4f;
            this.leg1.xRot += f1 * 0.6f;
            this.leg2.xRot += f1 * 0.6f;
        } else if (zombie.throwHitTick == -1) {
            this.waist.xRot -= 0.19634955f;
            this.chest.xRot -= 0.6f;
            this.arm1.xRot -= 2.6f;
            this.arm2.xRot -= 2.6f;
            this.leg1.xRot += 0.6f;
            this.leg2.xRot += 0.6f;
        } else if (zombie.throwHitTick < 5) {
            float tick = ((float)zombie.throwHitTick + this.partialTick) / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot -= f * 0.39634955f - 0.2f;
            this.chest.xRot -= f * 0.8f - 0.2f;
            Animator.addRotationAngle(this.arm1, -(f * 2.2f + 0.4f), -f1 * (float)Math.PI / 8.0f, f1 * 0.4f);
            Animator.addRotationAngle(this.arm2, -(f * 2.2f + 0.4f), f1 * (float)Math.PI / 8.0f, -f1 * 0.4f);
            this.forearm1.xRot += f1 * 0.2f;
            this.forearm2.xRot += f1 * 0.2f;
            this.leg1.xRot += f * 0.8f - 0.2f;
            this.leg2.xRot += f * 0.8f - 0.2f;
        } else if (zombie.throwFinishTick == -1) {
            this.waist.xRot += 0.2f;
            this.chest.xRot += 0.2f;
            Animator.addRotationAngle(this.arm1, -0.4f, -0.3926991f, 0.4f);
            Animator.addRotationAngle(this.arm2, -0.4f, 0.3926991f, -0.4f);
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
            this.leg1.xRot -= 0.2f;
            this.leg2.xRot -= 0.2f;
        } else if (zombie.throwFinishTick < 10) {
            float tick = ((float)zombie.throwFinishTick + this.partialTick) / 10.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.2f;
            Animator.addRotationAngle(this.arm1, -f * 0.4f, -f * (float)Math.PI / 8.0f, f * 0.4f);
            Animator.addRotationAngle(this.arm1, -f * 0.4f, f * (float)Math.PI / 8.0f, -f * 0.4f);
            this.forearm1.xRot += f * 0.2f;
            this.forearm2.xRot += f * 0.2f;
            this.leg1.xRot -= f * 0.2f;
            this.leg2.xRot -= f * 0.2f;
        }
    }

    private void animateDeath(MutantZombie zombie) {
        if (zombie.deathTime <= 20) {
            float tick = ((float)zombie.deathTime + this.partialTick - 1.0f) / 20.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.y += f * 28.0f;
            this.head.xRot -= f * (float)Math.PI / 10.0f;
            this.head.yRot += f * (float)Math.PI / 5.0f;
            this.chest.xRot -= f * (float)Math.PI / 12.0f;
            this.waist.xRot -= f * (float)Math.PI / 10.0f;
            this.arm1.xRot -= f * (float)Math.PI / 2.0f;
            this.arm1.yRot += f * (float)Math.PI / 2.8f;
            this.arm2.xRot -= f * (float)Math.PI / 2.0f;
            this.arm2.yRot -= f * (float)Math.PI / 2.8f;
            this.leg1.xRot += f * (float)Math.PI / 6.0f;
            this.leg1.zRot += f * (float)Math.PI / 12.0f;
            this.leg2.xRot += f * (float)Math.PI / 6.0f;
            this.leg2.zRot -= f * (float)Math.PI / 12.0f;
        } else if (zombie.deathTime <= 100) {
            this.pelvis.y += 28.0f;
            this.head.xRot -= 0.31415927f;
            this.head.yRot += 0.62831855f;
            this.chest.xRot -= 0.2617994f;
            this.waist.xRot -= 0.31415927f;
            this.arm1.xRot -= 1.0f;
            this.arm1.yRot += 1.0f;
            this.arm2.xRot -= 1.0f;
            this.arm2.yRot -= 1.0f;
            this.leg1.xRot += 0.5235988f;
            this.leg1.zRot += 0.2617994f;
            this.leg2.xRot += 0.5235988f;
            this.leg2.zRot -= 0.2617994f;
        } else {
            float tick = ((float)(40 - (140 - zombie.deathTime)) + this.partialTick) / 40.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.y += f * 28.0f;
            this.head.xRot -= f * (float)Math.PI / 10.0f;
            this.head.yRot += f * (float)Math.PI / 5.0f;
            this.chest.xRot -= f * (float)Math.PI / 12.0f;
            this.waist.xRot -= f * (float)Math.PI / 10.0f;
            this.arm1.xRot -= f * (float)Math.PI / 2.0f;
            this.arm1.yRot += f * (float)Math.PI / 2.8f;
            this.arm2.xRot -= f * (float)Math.PI / 2.0f;
            this.arm2.yRot -= f * (float)Math.PI / 2.8f;
            this.leg1.xRot += f * (float)Math.PI / 6.0f;
            this.leg1.zRot += f * (float)Math.PI / 12.0f;
            this.leg2.xRot += f * (float)Math.PI / 6.0f;
            this.leg2.zRot -= f * (float)Math.PI / 12.0f;
        }
    }

    public void prepareMobModel(MutantZombie entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }
}

