/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantEndermanModel
extends EntityModel<MutantEnderman> {
    private final ModelPart pelvis;
    private final ModelPart abdomen;
    private final ModelPart chest;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart mouth;
    private final Arm rightArm;
    private final Arm leftArm;
    private final Arm lowerRightArm;
    private final Arm lowerLeftArm;
    private final ModelPart legJoint1;
    private final ModelPart legJoint2;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart foreLeg1;
    private final ModelPart foreLeg2;
    private float partialTick;

    public MutantEndermanModel(ModelPart modelPart) {
        this.pelvis = modelPart.getChild("pelvis");
        this.abdomen = this.pelvis.getChild("abdomen");
        this.chest = this.abdomen.getChild("chest");
        this.neck = this.chest.getChild("neck");
        this.head = this.neck.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.rightArm = new Arm("right_", this.chest, true);
        this.leftArm = new Arm("left_", this.chest, false);
        this.lowerRightArm = new Arm("lower_right_", this.chest, true);
        this.lowerLeftArm = new Arm("lower_left_", this.chest, false);
        this.legJoint1 = this.abdomen.getChild("leg_joint1");
        this.legJoint2 = this.abdomen.getChild("leg_joint2");
        this.leg1 = this.legJoint1.getChild("leg1");
        this.leg2 = this.legJoint2.getChild("leg2");
        this.foreLeg1 = this.leg1.getChild("fore_leg1");
        this.foreLeg2 = this.leg2.getChild("fore_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pelvis = root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)-15.5f, (float)8.0f));
        PartDefinition abdomen = pelvis.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.ZERO);
        PartDefinition chest = abdomen.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(50, 8).addBox(-5.0f, -16.0f, -3.0f, 10.0f, 16.0f, 6.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition neck = chest.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(32, 14).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 14).addBox(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)3.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f), PartPose.ZERO);
        Arm.createArmLayer("right_", chest, true, false);
        Arm.createArmLayer("left_", chest, false, false);
        Arm.createArmLayer("lower_right_", chest, true, true);
        Arm.createArmLayer("lower_left_", chest, false, true);
        PartDefinition legJoint1 = abdomen.addOrReplaceChild("leg_joint1", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)-1.5f, (float)0.0f, (float)0.75f));
        PartDefinition legJoint2 = abdomen.addOrReplaceChild("leg_joint2", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)1.5f, (float)0.0f, (float)0.75f));
        PartDefinition leg1 = legJoint1.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leg2 = legJoint2.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 34).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        leg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(12, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        leg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(12, 34).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.pelvis.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(MutantEnderman entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float armScale = entityIn.getArmScale(this.partialTick);
        MutantEndermanModel.setModelPartScale(this.lowerRightArm.arm, armScale);
        MutantEndermanModel.setModelPartScale(this.lowerLeftArm.arm, armScale);
    }

    private static void setModelPartScale(ModelPart modelPart, float scale) {
        if (scale != 0.0f) {
            modelPart.visible = true;
            modelPart.yScale = modelPart.zScale = scale;
            modelPart.xScale = modelPart.zScale;
        } else {
            modelPart.visible = false;
        }
    }

    private void setAngles() {
        this.pelvis.y = -15.5f;
        this.abdomen.xRot = 0.31415927f;
        this.chest.xRot = 0.3926991f;
        this.chest.yRot = 0.0f;
        this.chest.zRot = 0.0f;
        this.neck.xRot = 0.19634955f;
        this.neck.zRot = 0.0f;
        this.head.xRot = -0.7853982f;
        this.head.yRot = 0.0f;
        this.head.zRot = 0.0f;
        this.mouth.xRot = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.xRot += 0.1f;
        this.lowerRightArm.arm.zRot -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.xRot += 0.1f;
        this.lowerLeftArm.arm.zRot += 0.2f;
        this.legJoint1.xRot = 0.0f;
        this.legJoint2.xRot = 0.0f;
        this.leg1.xRot = -0.8975979f;
        this.leg1.yRot = 0.0f;
        this.leg1.zRot = 0.2617994f;
        this.leg2.xRot = -0.8975979f;
        this.leg2.yRot = 0.0f;
        this.leg2.zRot = -0.2617994f;
        this.foreLeg1.xRot = 0.7853982f;
        this.foreLeg1.zRot = -0.1308997f;
        this.foreLeg2.xRot = 0.7853982f;
        this.foreLeg2.zRot = 0.1308997f;
    }

    private void animate(MutantEnderman enderman, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float scale;
        int arm;
        float walkSpeed = 0.3f;
        float walkAnim1 = (Mth.sin((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float walkAnim2 = -(Mth.sin((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim3 = (Mth.sin((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim4 = -(Mth.sin((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, Mth.sin((float)(limbSwing * walkSpeed)) * limbSwingAmount);
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.15f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        for (arm = 0; arm < 4; ++arm) {
            if (enderman.getHeldBlock(arm) <= 0) continue;
            this.animateHoldBlock(enderman.getHeldBlockTick(arm), arm, enderman.hasTarget > 0);
            int n = arm;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (enderman.getAnimation() == MutantEnderman.MELEE_ANIMATION) {
            arm = enderman.getActiveArm();
            this.animateMelee(enderman.getAnimationTick(), arm);
            walkAnim[arm] = 0.0f;
        }
        if (enderman.getAnimation() == MutantEnderman.THROW_ANIMATION) {
            this.animateThrowBlock(enderman.getAnimationTick(), enderman.getActiveArm());
        }
        if (enderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
            this.animateScream(enderman.getAnimationTick());
            scale = 1.0f - Mth.clamp((float)((float)enderman.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (enderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION) {
            this.animateTeleSmash(enderman.getAnimationTick());
        }
        if (enderman.getAnimation() == MutantEnderman.DEATH_ANIMATION) {
            this.animateDeath(enderman.deathTime);
            scale = 1.0f - Mth.clamp((float)((float)enderman.deathTime / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.xRot += facePitch * 0.5f;
        this.head.yRot += faceYaw * 0.7f;
        this.head.zRot -= faceYaw * 0.7f;
        this.neck.xRot += facePitch * 0.3f;
        this.chest.xRot += facePitch * 0.2f;
        this.mouth.xRot += breatheAnim * 0.02f + 0.02f;
        this.neck.xRot -= breatheAnim * 0.02f;
        this.rightArm.arm.zRot += breatheAnim * 0.004f;
        this.leftArm.arm.zRot -= breatheAnim * 0.004f;
        for (ModelPart finger : this.rightArm.finger) {
            finger.zRot += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.zRot -= breatheAnim * 0.05f;
        for (ModelPart finger : this.leftArm.finger) {
            finger.zRot -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.zRot += breatheAnim * 0.05f;
        this.lowerRightArm.arm.zRot += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.zRot -= breatheAnim * 0.002f;
        for (ModelPart finger : this.lowerRightArm.finger) {
            finger.zRot += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.zRot -= breatheAnim * 0.02f;
        for (ModelPart finger : this.lowerLeftArm.finger) {
            finger.zRot -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.zRot += breatheAnim * 0.02f;
        this.pelvis.y -= Math.abs(walkAnim[4]);
        this.chest.yRot -= walkAnim[4] * 0.06f;
        this.rightArm.arm.xRot -= walkAnim[0] * 0.6f;
        this.leftArm.arm.xRot += walkAnim[1] * 0.6f;
        this.rightArm.foreArm.xRot -= walkAnim[0] * 0.2f;
        this.leftArm.foreArm.xRot += walkAnim[1] * 0.2f;
        this.lowerRightArm.arm.xRot -= walkAnim[2] * 0.3f;
        this.lowerLeftArm.arm.xRot += walkAnim[3] * 0.3f;
        this.lowerRightArm.foreArm.xRot -= walkAnim[2] * 0.1f;
        this.lowerLeftArm.foreArm.xRot += walkAnim[3] * 0.1f;
        this.legJoint1.xRot += walkAnim1 * 0.6f;
        this.legJoint2.xRot += walkAnim2 * 0.6f;
        this.foreLeg1.xRot += walkAnim3 * 0.3f;
        this.foreLeg2.xRot += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(int fullTick, int armID, boolean hasTarget) {
        float tick = ((float)fullTick + this.partialTick) / 10.0f;
        if (!hasTarget) {
            tick = fullTick == 0 ? 0.0f : ((float)fullTick - this.partialTick) / 10.0f;
        }
        float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
        if (armID == 0) {
            this.rightArm.arm.zRot += f * 0.8f;
            this.rightArm.foreArm.zRot += f * 0.6f;
            this.rightArm.hand.yRot += f * 0.8f;
            this.rightArm.finger[0].xRot += -f * 0.2f;
            this.rightArm.finger[2].xRot += f * 0.2f;
            for (ModelPart finger : this.rightArm.finger) {
                finger.zRot += f * 0.6f;
            }
            this.rightArm.thumb.zRot += -f * 0.4f;
        } else if (armID == 1) {
            this.leftArm.arm.zRot += -f * 0.8f;
            this.leftArm.foreArm.zRot += -f * 0.6f;
            this.leftArm.hand.yRot += -f * 0.8f;
            this.leftArm.finger[0].xRot += -f * 0.2f;
            this.leftArm.finger[2].xRot += f * 0.2f;
            for (ModelPart finger : this.leftArm.finger) {
                finger.zRot += -f * 0.6f;
            }
            this.leftArm.thumb.zRot += f * 0.4f;
        } else if (armID == 2) {
            this.lowerRightArm.arm.zRot += f * 0.5f;
            this.lowerRightArm.foreArm.zRot += f * 0.4f;
            this.lowerRightArm.hand.yRot += f * 0.4f;
            this.lowerRightArm.finger[0].xRot += -f * 0.2f;
            this.lowerRightArm.finger[2].xRot += f * 0.2f;
            for (ModelPart finger : this.lowerRightArm.finger) {
                finger.zRot += f * 0.6f;
            }
            this.lowerRightArm.thumb.zRot += -f * 0.4f;
        } else if (armID == 3) {
            this.lowerLeftArm.arm.zRot += -f * 0.5f;
            this.lowerLeftArm.foreArm.zRot += -f * 0.4f;
            this.lowerLeftArm.hand.yRot += -f * 0.4f;
            this.lowerLeftArm.finger[0].xRot += -f * 0.2f;
            this.lowerLeftArm.finger[2].xRot += f * 0.2f;
            for (ModelPart finger : this.lowerLeftArm.finger) {
                finger.zRot += -f * 0.6f;
            }
            this.lowerLeftArm.thumb.zRot += f * 0.4f;
        }
    }

    private void animateMelee(int fullTick, int armID) {
        int right = (armID & 1) == 0 ? 1 : -1;
        Arm arm = this.getArmFromID(armID);
        if (fullTick < 2) {
            float tick = ((float)fullTick + this.partialTick) / 2.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            ModelPart var10000 = arm.arm;
            var10000.xRot += f * 0.2f;
            ModelPart var8 = arm.finger[0];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.zRot += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.zRot += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.zRot += -f * 0.5f * (float)right;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 2) + this.partialTick) / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.chest.yRot += -f1 * 0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.xRot += f * 1.1f - 1.1f;
            ModelPart var8 = arm.foreArm;
            var8.xRot += -f * 0.4f;
            var8 = arm.finger[0];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.zRot += -0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.zRot += -0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.zRot += -0.5f * (float)right;
        } else if (fullTick < 6) {
            this.chest.yRot += -0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.xRot += -1.1f;
            ModelPart var8 = arm.foreArm;
            var8.xRot += -0.4f;
            var8 = arm.finger[0];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.zRot += 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.zRot += -0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.zRot += -0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.zRot += -0.5f * (float)right;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 6) + this.partialTick) / 4.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.chest.yRot += -f * 0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.xRot += -f * 1.1f;
            ModelPart var8 = arm.foreArm;
            var8.xRot += -f * 0.4f;
            var8 = arm.finger[0];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.zRot += f * 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.zRot += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.zRot += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.zRot += -f * 0.5f * (float)right;
        }
    }

    private void animateThrowBlock(int fullTick, int armID) {
        if (armID == 0) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.xRot += -f1 * 1.5f;
                this.rightArm.arm.zRot += f * 0.8f;
                this.rightArm.foreArm.zRot += f * 0.6f;
                this.rightArm.hand.yRot += f * 0.8f;
                this.rightArm.finger[0].xRot += -f * 0.2f;
                this.rightArm.finger[2].xRot += f * 0.2f;
                for (ModelPart finger : this.rightArm.finger) {
                    finger.zRot += f * 0.6f;
                }
                this.rightArm.thumb.zRot += -f * 0.4f;
            } else if (fullTick < 7) {
                this.rightArm.arm.xRot += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.xRot += -f * 1.5f;
            }
        } else if (armID == 1) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.xRot += -f1 * 1.5f;
                this.leftArm.arm.zRot += -f * 0.8f;
                this.leftArm.foreArm.zRot += -f * 0.6f;
                this.leftArm.hand.yRot += -f * 0.8f;
                this.leftArm.finger[0].xRot += -f * 0.2f;
                this.leftArm.finger[2].xRot += f * 0.2f;
                for (int var8 = 0; var8 < this.leftArm.finger.length; ++var8) {
                    ModelPart finger = this.leftArm.finger[var8];
                    finger.zRot += -f * 0.6f;
                }
                this.leftArm.thumb.zRot += f * 0.4f;
            } else if (fullTick < 7) {
                this.leftArm.arm.xRot += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.xRot += -f * 1.5f;
            }
        } else if (armID == 2) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.xRot += -f1 * 1.5f;
                this.lowerRightArm.arm.zRot += f * 0.5f;
                this.lowerRightArm.foreArm.zRot += f * 0.4f;
                this.lowerRightArm.hand.yRot += f * 0.4f;
                this.lowerRightArm.finger[0].xRot += -f * 0.2f;
                this.lowerRightArm.finger[2].xRot += f * 0.2f;
                for (ModelPart finger : this.lowerRightArm.finger) {
                    finger.zRot += f * 0.6f;
                }
                this.lowerRightArm.thumb.zRot += -f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerRightArm.arm.xRot += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.xRot += -f * 1.5f;
            }
        } else if (armID == 3) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.xRot += -f1 * 1.5f;
                this.lowerLeftArm.arm.zRot += -f * 0.5f;
                this.lowerLeftArm.foreArm.zRot += -f * 0.4f;
                this.lowerLeftArm.hand.yRot += -f * 0.4f;
                this.lowerLeftArm.finger[0].xRot += -f * 0.2f;
                this.lowerLeftArm.finger[2].xRot += f * 0.2f;
                for (ModelPart finger : this.lowerLeftArm.finger) {
                    finger.zRot += -f * 0.6f;
                }
                this.lowerLeftArm.thumb.zRot += f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerLeftArm.arm.xRot += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.xRot += -f * 1.5f;
            }
        }
    }

    private void animateScream(int fullTick) {
        if (fullTick < 35) {
            int i;
            float tick = ((float)fullTick + this.partialTick) / 35.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += f * 0.3f;
            this.chest.xRot += f * 0.4f;
            this.neck.xRot += f * 0.2f;
            this.head.xRot += f * 0.3f;
            this.rightArm.arm.xRot += -f * 0.6f;
            this.rightArm.arm.yRot += f * 0.4f;
            this.rightArm.foreArm.xRot += -f * 0.8f;
            this.rightArm.hand.zRot += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += f * 0.3f;
                this.rightArm.foreFinger[i].zRot += -f * 0.5f;
            }
            this.leftArm.arm.xRot += -f * 0.6f;
            this.leftArm.arm.yRot += -f * 0.4f;
            this.leftArm.foreArm.xRot += -f * 0.8f;
            this.leftArm.hand.zRot += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -f * 0.3f;
                this.leftArm.foreFinger[i].zRot += f * 0.5f;
            }
            this.lowerRightArm.arm.xRot += -f * 0.4f;
            this.lowerRightArm.arm.yRot += f * 0.2f;
            this.lowerRightArm.foreArm.xRot += -f * 0.8f;
            this.lowerRightArm.hand.zRot += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += f * 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -f * 0.5f;
            }
            this.lowerLeftArm.arm.xRot += -f * 0.4f;
            this.lowerLeftArm.arm.yRot += -f * 0.2f;
            this.lowerLeftArm.foreArm.xRot += -f * 0.8f;
            this.lowerLeftArm.hand.zRot += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += f * 0.5f;
            }
        } else if (fullTick < 40) {
            int i;
            this.abdomen.xRot += 0.3f;
            this.chest.xRot += 0.4f;
            this.neck.xRot += 0.2f;
            this.head.xRot += 0.3f;
            this.rightArm.arm.xRot += -0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.rightArm.foreArm.xRot += -0.8f;
            this.rightArm.hand.zRot += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += 0.3f;
                this.rightArm.foreFinger[i].zRot += -0.5f;
            }
            this.leftArm.arm.xRot += -0.6f;
            this.leftArm.arm.yRot += -0.4f;
            this.leftArm.foreArm.xRot += -0.8f;
            this.leftArm.hand.zRot += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -0.3f;
                this.leftArm.foreFinger[i].zRot += 0.5f;
            }
            this.lowerRightArm.arm.xRot += -0.4f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.foreArm.xRot += -0.8f;
            this.lowerRightArm.hand.zRot += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -0.5f;
            }
            this.lowerLeftArm.arm.xRot += -0.4f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.foreArm.xRot += -0.8f;
            this.lowerLeftArm.hand.zRot += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += 0.5f;
            }
        } else if (fullTick < 44) {
            int i;
            float tick = ((float)(fullTick - 40) + this.partialTick) / 4.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += -f * 0.1f + 0.4f;
            this.chest.xRot += f * 0.1f + 0.3f;
            this.chest.zRot += f1 * 0.5f;
            this.neck.xRot += f * 0.2f;
            this.neck.zRot += f1 * 0.2f;
            this.head.xRot += f * 1.2f - 0.8f;
            this.head.zRot += f1 * 0.4f;
            this.mouth.xRot += f1 * 0.6f;
            this.rightArm.arm.xRot += -f * 0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.rightArm.foreArm.xRot += -f * 0.8f;
            this.rightArm.hand.zRot += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += f * 0.3f;
                this.rightArm.foreFinger[i].zRot += -f * 0.5f;
            }
            this.leftArm.arm.xRot += -f * 0.6f;
            this.leftArm.arm.yRot += -0.4f;
            this.leftArm.foreArm.xRot += -f * 0.8f;
            this.leftArm.hand.zRot += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -f * 0.3f;
                this.leftArm.foreFinger[i].zRot += f * 0.5f;
            }
            this.lowerRightArm.arm.xRot += -f * 0.4f;
            this.lowerRightArm.arm.yRot += -f * 0.1f + 0.3f;
            this.lowerRightArm.foreArm.xRot += -f * 0.8f;
            this.lowerRightArm.hand.zRot += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += f * 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -f * 0.5f;
            }
            this.lowerLeftArm.arm.xRot += -f * 0.4f;
            this.lowerLeftArm.arm.yRot += f * 0.1f - 0.3f;
            this.lowerLeftArm.foreArm.xRot += -f * 0.8f;
            this.lowerLeftArm.hand.zRot += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += f * 0.5f;
            }
            this.leg1.zRot += f1 * 0.1f;
            this.leg2.zRot += -f1 * 0.1f;
        } else if (fullTick < 155) {
            float tick = ((float)(fullTick - 44) + this.partialTick) / 111.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += 0.4f;
            this.chest.xRot += 0.3f;
            this.chest.zRot += f - 0.5f;
            this.neck.zRot += f * 0.4f - 0.2f;
            this.head.xRot += -0.8f;
            this.head.zRot += f * 0.8f - 0.4f;
            this.mouth.xRot += 0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.leftArm.arm.yRot += -0.4f;
            this.lowerRightArm.arm.yRot += 0.3f;
            this.lowerLeftArm.arm.yRot += -0.3f;
            this.leg1.zRot += 0.1f;
            this.leg2.zRot += -0.1f;
        } else if (fullTick < 160) {
            float tick = ((float)(fullTick - 155) + this.partialTick) / 5.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.xRot += f * 0.4f;
            this.chest.xRot += f * 0.3f;
            this.chest.zRot += -f * 0.5f;
            this.neck.zRot += -f * 0.2f;
            this.head.xRot += -f * 0.8f;
            this.head.zRot += -f * 0.4f;
            this.mouth.xRot += f * 0.6f;
            this.rightArm.arm.yRot += f * 0.4f;
            this.leftArm.arm.yRot += -f * 0.4f;
            this.lowerRightArm.arm.yRot += f * 0.3f;
            this.lowerLeftArm.arm.yRot += -f * 0.3f;
            this.leg1.zRot += f * 0.1f;
            this.leg2.zRot += -f * 0.1f;
        }
    }

    private void animateTeleSmash(int fullTick) {
        if (fullTick < 18) {
            float tick = ((float)fullTick + this.partialTick) / 18.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.chest.xRot += -f * 0.3f;
            this.rightArm.arm.yRot += f * 0.2f;
            this.rightArm.arm.zRot += f * 0.8f;
            this.rightArm.hand.yRot += f * 1.7f;
            this.leftArm.arm.yRot += -f * 0.2f;
            this.leftArm.arm.zRot += -f * 0.8f;
            this.leftArm.hand.yRot += -f * 1.7f;
            this.lowerRightArm.arm.yRot += f * 0.2f;
            this.lowerRightArm.arm.zRot += f * 0.6f;
            this.lowerRightArm.hand.yRot += f * 1.7f;
            this.lowerLeftArm.arm.yRot += -f * 0.2f;
            this.lowerLeftArm.arm.zRot += -f * 0.6f;
            this.lowerLeftArm.hand.yRot += -f * 1.7f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 18) + this.partialTick) / 2.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.chest.xRot += -f * 0.3f;
            this.rightArm.arm.xRot += -f1 * 0.8f;
            this.rightArm.arm.yRot += 0.2f;
            this.rightArm.arm.zRot += 0.8f;
            this.rightArm.hand.yRot += 1.0f;
            this.leftArm.arm.xRot += -f1 * 0.8f;
            this.leftArm.arm.yRot += -0.2f;
            this.leftArm.arm.zRot += -0.8f;
            this.leftArm.hand.yRot += -1.7f;
            this.lowerRightArm.arm.xRot += -f1 * 0.9f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.arm.zRot += 0.6f;
            this.lowerRightArm.hand.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += -f1 * 0.9f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.arm.zRot += -0.6f;
            this.lowerLeftArm.hand.yRot += -1.7f;
        } else if (fullTick < 24) {
            this.rightArm.arm.xRot += -0.8f;
            this.rightArm.arm.yRot += 0.2f;
            this.rightArm.arm.zRot += 0.8f;
            this.rightArm.hand.yRot += 1.0f;
            this.leftArm.arm.xRot += -0.8f;
            this.leftArm.arm.yRot += -0.2f;
            this.leftArm.arm.zRot += -0.8f;
            this.leftArm.hand.yRot += -1.7f;
            this.lowerRightArm.arm.xRot += -0.9f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.arm.zRot += 0.6f;
            this.lowerRightArm.hand.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += -0.9f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.arm.zRot += -0.6f;
            this.lowerLeftArm.hand.yRot += -1.7f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 24) + this.partialTick) / 6.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.rightArm.arm.xRot += -f * 0.8f;
            this.rightArm.arm.yRot += f * 0.2f;
            this.rightArm.arm.zRot += f * 0.8f;
            this.rightArm.hand.yRot += f * 1.7f;
            this.leftArm.arm.xRot += -f * 0.8f;
            this.leftArm.arm.yRot += -f * 0.2f;
            this.leftArm.arm.zRot += -f * 0.8f;
            this.leftArm.hand.yRot += -f * 1.7f;
            this.lowerRightArm.arm.xRot += -f * 0.9f;
            this.lowerRightArm.arm.yRot += f * 0.2f;
            this.lowerRightArm.arm.zRot += f * 0.6f;
            this.lowerRightArm.hand.yRot += f * 1.7f;
            this.lowerLeftArm.arm.xRot += -f * 0.9f;
            this.lowerLeftArm.arm.yRot += -f * 0.2f;
            this.lowerLeftArm.arm.zRot += -f * 0.6f;
            this.lowerLeftArm.hand.yRot += -f * 1.7f;
        }
    }

    private void animateDeath(int deathTick) {
        if (deathTick < 80) {
            float tick = ((float)deathTick + this.partialTick) / 80.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.head.xRot += f * 0.4f;
            this.neck.xRot += f * 0.3f;
            this.pelvis.y += -f * 12.0f;
            this.rightArm.arm.xRot += -f * 0.4f;
            this.rightArm.arm.yRot += f * 0.4f;
            this.rightArm.arm.zRot += f * 0.6f;
            this.rightArm.foreArm.xRot += -f * 1.2f;
            this.leftArm.arm.xRot += -f * 0.4f;
            this.leftArm.arm.yRot += -f * 0.2f;
            this.leftArm.arm.zRot += -f * 0.6f;
            this.leftArm.foreArm.xRot += -f * 1.2f;
            this.lowerRightArm.arm.xRot += -f * 0.4f;
            this.lowerRightArm.arm.yRot += f * 0.4f;
            this.lowerRightArm.arm.zRot += f * 0.6f;
            this.lowerRightArm.foreArm.xRot += -f * 1.2f;
            this.lowerLeftArm.arm.xRot += -f * 0.4f;
            this.lowerLeftArm.arm.yRot += -f * 0.2f;
            this.lowerLeftArm.arm.zRot += -f * 0.6f;
            this.lowerLeftArm.foreArm.xRot += -f * 1.2f;
            this.leg1.xRot += -f * 0.9f;
            this.leg1.yRot += f * 0.3f;
            this.leg2.xRot += -f * 0.9f;
            this.leg2.yRot += -f * 0.3f;
            this.foreLeg1.xRot += f * 1.6f;
            this.foreLeg2.xRot += f * 1.6f;
        } else if (deathTick < 84) {
            float tick = ((float)(deathTick - 80) + this.partialTick) / 4.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.head.xRot += f * 0.4f;
            this.mouth.xRot += f1 * 0.6f;
            this.neck.xRot += f * 0.4f - 0.1f;
            this.chest.xRot += -f1 * 0.8f;
            this.abdomen.xRot += -f1 * 0.2f;
            this.pelvis.y += -12.0f;
            this.rightArm.arm.xRot += -f * 0.4f;
            this.rightArm.arm.yRot += -f * 1.4f + 1.8f;
            this.rightArm.arm.zRot += f * 0.6f;
            this.rightArm.foreArm.xRot += -f * 1.2f;
            this.leftArm.arm.xRot += -f * 0.4f;
            this.leftArm.arm.yRot += f * 1.6f - 1.8f;
            this.leftArm.arm.zRot += -f * 0.6f;
            this.leftArm.foreArm.xRot += -f * 1.2f;
            this.lowerRightArm.arm.xRot += -f * 0.5f + 0.1f;
            this.lowerRightArm.arm.yRot += -f * 1.1f + 1.5f;
            this.lowerRightArm.arm.zRot += f * 0.6f;
            this.lowerRightArm.foreArm.xRot += -f * 1.2f;
            this.lowerLeftArm.arm.xRot += -f * 0.5f + 0.1f;
            this.lowerLeftArm.arm.yRot += f * 1.1f - 1.5f;
            this.lowerLeftArm.arm.zRot += -f * 0.6f;
            this.lowerLeftArm.foreArm.xRot += -f * 1.2f;
            this.leg1.xRot += -f * 1.7f + 0.8f;
            this.leg1.yRot += f * 0.3f;
            this.leg1.zRot += f1 * 0.2f;
            this.leg2.xRot += -f * 1.7f + 0.8f;
            this.leg2.yRot += -f * 0.3f;
            this.leg2.zRot += -f1 * 0.2f;
            this.foreLeg1.xRot += f * 1.6f;
            this.foreLeg2.xRot += f * 1.6f;
        } else {
            this.mouth.xRot += 0.6f;
            this.neck.xRot += -0.1f;
            this.chest.xRot += -0.8f;
            this.abdomen.xRot += -0.2f;
            this.pelvis.y += -12.0f;
            this.rightArm.arm.yRot += 1.0f;
            this.leftArm.arm.yRot += -1.8f;
            this.lowerRightArm.arm.xRot += 0.1f;
            this.lowerRightArm.arm.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += 0.1f;
            this.lowerLeftArm.arm.yRot += -1.5f;
            this.leg1.xRot += 0.8f;
            this.leg1.zRot += 0.2f;
            this.leg2.xRot += 0.8f;
            this.leg2.zRot += -0.2f;
        }
    }

    private Arm getArmFromID(int armID) {
        return armID == 0 ? this.rightArm : (armID == 1 ? this.leftArm : (armID == 2 ? this.lowerRightArm : this.lowerLeftArm));
    }

    public void translateRotateArm(PoseStack matrixStackIn, int armID) {
        this.pelvis.translateAndRotate(matrixStackIn);
        this.abdomen.translateAndRotate(matrixStackIn);
        this.chest.translateAndRotate(matrixStackIn);
        this.getArmFromID(armID).translateRotate(matrixStackIn);
    }

    public void prepareMobModel(MutantEnderman entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    static class Arm {
        private final ModelPart arm;
        private final ModelPart foreArm;
        private final ModelPart hand;
        private final ModelPart[] finger = new ModelPart[3];
        private final ModelPart[] foreFinger = new ModelPart[3];
        private final ModelPart thumb;
        private final boolean right;

        private Arm(String prefix, ModelPart modelPart, boolean right) {
            this.right = right;
            this.arm = modelPart.getChild(prefix + "arm");
            this.foreArm = this.arm.getChild(prefix + "fore_arm");
            this.hand = this.foreArm.getChild(prefix + "hand");
            for (int i = 0; i < 3; ++i) {
                this.finger[i] = this.hand.getChild(prefix + "finger" + i);
                this.foreFinger[i] = this.finger[i].getChild(prefix + "fore_finger" + i);
            }
            this.thumb = this.hand.getChild(prefix + "thumb");
        }

        static void createArmLayer(String prefix, PartDefinition root, boolean right, boolean lower) {
            PartDefinition arm = root.addOrReplaceChild(prefix + "arm", CubeListBuilder.create().texOffs(92, 0).addBox(-1.5f, lower ? 6.0f : 0.0f, -1.5f, 3.0f, 22.0f, 3.0f, new CubeDeformation(0.1f)).mirror(!right), PartPose.offset((float)(right ? -4.0f : 4.0f), (float)-14.0f, (float)0.0f));
            PartDefinition foreArm = arm.addOrReplaceChild(prefix + "fore_arm", CubeListBuilder.create().texOffs(104, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 18.0f, 3.0f).mirror(!right), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
            PartDefinition hand = foreArm.addOrReplaceChild(prefix + "hand", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)17.5f, (float)0.0f));
            for (int i = 0; i < 3; ++i) {
                PartPose partPose = i == 0 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)-1.0f) : (i == 1 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)0.0f) : PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)1.0f));
                PartDefinition finger = hand.addOrReplaceChild(prefix + "finger" + i, CubeListBuilder.create().texOffs(76, 0).mirror(!right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.6f)), partPose);
                finger.addOrReplaceChild(prefix + "fore_finger" + i, CubeListBuilder.create().texOffs(76, 0).mirror(!right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.59000003f)), PartPose.offset((float)0.0f, (float)(0.5f + (float)(i == 1 ? 6 : 5)), (float)0.0f));
            }
            hand.addOrReplaceChild(prefix + "thumb", CubeListBuilder.create().texOffs(76, 0).mirror(right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offset((float)(right ? 0.5f : -0.5f), (float)0.0f, (float)-0.5f));
        }

        private void setAngles() {
            Animator.resetAngles(this.arm);
            Animator.resetAngles(this.foreArm);
            Animator.resetAngles(this.hand);
            for (int i = 0; i < this.finger.length; ++i) {
                Animator.resetAngles(this.finger[i]);
                Animator.resetAngles(this.foreFinger[i]);
            }
            Animator.resetAngles(this.thumb);
            if (this.right) {
                this.arm.xRot = -0.5235988f;
                this.arm.zRot = 0.5235988f;
                this.foreArm.xRot = -0.62831855f;
                this.hand.yRot = -0.3926991f;
                this.finger[0].xRot = -0.2617994f;
                this.finger[1].zRot = 0.17453294f;
                this.finger[2].xRot = 0.2617994f;
                this.foreFinger[0].zRot = -0.2617994f;
                this.foreFinger[1].zRot = -0.3926991f;
                this.foreFinger[2].zRot = -0.2617994f;
                this.thumb.xRot = -0.62831855f;
                this.thumb.zRot = -0.3926991f;
            } else {
                this.arm.xRot = -0.5235988f;
                this.arm.zRot = -0.5235988f;
                this.foreArm.xRot = -0.62831855f;
                this.hand.yRot = 0.3926991f;
                this.finger[0].xRot = -0.2617994f;
                this.finger[1].zRot = -0.17453294f;
                this.finger[2].xRot = 0.2617994f;
                this.foreFinger[0].zRot = 0.2617994f;
                this.foreFinger[1].zRot = 0.3926991f;
                this.foreFinger[2].zRot = 0.2617994f;
                this.thumb.xRot = -0.62831855f;
                this.thumb.zRot = 0.3926991f;
            }
        }

        private void translateRotate(PoseStack matrixStackIn) {
            this.arm.translateAndRotate(matrixStackIn);
            this.foreArm.translateAndRotate(matrixStackIn);
            this.hand.translateAndRotate(matrixStackIn);
        }
    }
}

