/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class MutantCrossbowModel
extends Model {
    public final ModelPart armWear;
    public final ModelPart middle;
    public final ModelPart middle1;
    public final ModelPart middle2;
    public final ModelPart side1;
    public final ModelPart side2;
    public final ModelPart side3;
    public final ModelPart side4;
    public final ModelPart rope1;
    public final ModelPart rope2;

    public MutantCrossbowModel(ModelPart modelPart) {
        super(RenderType::entityCutoutNoCull);
        this.armWear = modelPart.getChild("arm_wear");
        this.middle = this.armWear.getChild("middle");
        this.middle1 = this.middle.getChild("middle1");
        this.middle2 = this.middle.getChild("middle2");
        this.side1 = this.middle1.getChild("side1");
        this.side2 = this.middle2.getChild("side2");
        this.side3 = this.side1.getChild("side3");
        this.side4 = this.side2.getChild("side4");
        this.rope1 = this.side3.getChild("rope1");
        this.rope2 = this.side4.getChild("rope2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition armWear = root.addOrReplaceChild("arm_wear", CubeListBuilder.create().texOffs(0, 64).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition middle = armWear.addOrReplaceChild("middle", CubeListBuilder.create().texOffs(16, 64).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 6.0f), PartPose.offset((float)-3.5f, (float)0.0f, (float)0.0f));
        PartDefinition middle1 = middle.addOrReplaceChild("middle1", CubeListBuilder.create().texOffs(36, 64).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.6f, (float)-4.0f));
        PartDefinition middle2 = middle.addOrReplaceChild("middle2", CubeListBuilder.create().texOffs(36, 64).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.6f, (float)4.0f));
        PartDefinition side1 = middle1.addOrReplaceChild("side1", CubeListBuilder.create().texOffs(0, 74).addBox(-1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition side2 = middle2.addOrReplaceChild("side2", CubeListBuilder.create().texOffs(0, 74).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition side3 = side1.addOrReplaceChild("side3", CubeListBuilder.create().texOffs(20, 74).addBox(-0.5f, -0.5f, -8.0f, 1.0f, 1.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        PartDefinition side4 = side2.addOrReplaceChild("side4", CubeListBuilder.create().texOffs(20, 74).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        side3.addOrReplaceChild("rope1", CubeListBuilder.create().texOffs(0, 84).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 15.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        side4.addOrReplaceChild("rope2", CubeListBuilder.create().texOffs(0, 84).addBox(-0.5f, -0.5f, -15.0f, 1.0f, 1.0f, 15.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setAngles(float PI) {
        this.middle1.xRot = PI / 8.0f;
        this.middle2.xRot = -PI / 8.0f;
        this.side1.xRot = -PI / 5.0f;
        this.side2.xRot = PI / 5.0f;
        this.side3.xRot = -PI / 4.0f;
        this.side4.xRot = PI / 4.0f;
    }

    public void rotateRope() {
        this.rope1.xRot = -(this.middle1.xRot + this.side1.xRot + this.side3.xRot);
        this.rope2.xRot = -(this.middle2.xRot + this.side2.xRot + this.side4.xRot);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.armWear.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

