/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.wanderingtradermayleave_common_forge.button;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SmallTextButton
extends Button {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));

    public SmallTextButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Font font = Minecraft.getInstance().font;
        graphics.blitSprite(SPRITES.get(this.active, this.isHovered(mouseX, mouseY)), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        float scale = 0.66f;
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 1.0f);
        int scaledX = (int)(((double)this.getX() + 0.5 + (double)((float)this.getWidth() / 2.0f) - (double)((float)font.width((FormattedText)this.getMessage()) * scale / 2.0f)) / (double)scale);
        double d = (double)this.getY() + 0.8 + (double)((float)this.getHeight() / 2.0f);
        Objects.requireNonNull(font);
        int scaledY = (int)((d - (double)(9.0f * scale / 2.0f)) / (double)scale);
        graphics.drawString(font, this.getMessage(), scaledX, scaledY, 0xFFFFFF);
        graphics.pose().popPose();
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }
}

