/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StructurePostProcessConnectiveBlocks
extends Feature<NoneFeatureConfiguration> {
    public StructurePostProcessConnectiveBlocks() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos.MutableBlockPos currentBlockMutable = new BlockPos.MutableBlockPos();
        ChunkPos currentChunkPos = new ChunkPos(context.origin());
        ChunkAccess currentChunk = context.level().getChunk(currentChunkPos.x, currentChunkPos.z);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) + Math.abs(z) != 1) continue;
                for (int y = 0; y >= -2; --y) {
                    BlockState currentBlock;
                    currentBlockMutable.set((Vec3i)context.origin()).move(x, y, z);
                    if (currentChunkPos.x != currentBlockMutable.getX() >> 4 || currentChunkPos.z != currentBlockMutable.getZ() >> 4) {
                        currentChunk = context.level().getChunk((BlockPos)currentBlockMutable);
                        currentChunkPos = new ChunkPos((BlockPos)currentBlockMutable);
                    }
                    if (!((currentBlock = currentChunk.getBlockState((BlockPos)currentBlockMutable)).getBlock() instanceof FenceBlock) && !(currentBlock.getBlock() instanceof WallBlock)) continue;
                    StructurePostProcessConnectiveBlocks.placeConnectBlock(context, currentBlockMutable, currentChunkPos, currentChunk, currentBlock);
                }
            }
        }
        return true;
    }

    protected static void placeConnectBlock(FeaturePlaceContext<?> context, BlockPos.MutableBlockPos currentBlockMutable, ChunkPos currentChunkPos, ChunkAccess currentChunk, BlockState incomingBlockState) {
        BlockPos.MutableBlockPos offsetMutable = new BlockPos.MutableBlockPos();
        if (incomingBlockState.getBlock() instanceof WallBlock) {
            BlockState currentState = incomingBlockState.getBlock().defaultBlockState();
            for (Direction direction : Direction.values()) {
                offsetMutable.set((Vec3i)currentBlockMutable).move(direction);
                if (currentChunkPos.x != offsetMutable.getX() >> 4 || currentChunkPos.z != offsetMutable.getZ() >> 4) continue;
                BlockState sideBlock = currentChunk.getBlockState((BlockPos)offsetMutable);
                currentState = currentState.updateShape(direction, sideBlock, (LevelAccessor)context.level(), (BlockPos)currentBlockMutable, (BlockPos)offsetMutable);
            }
            if (currentState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                currentState = (BlockState)currentState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)incomingBlockState.getValue((Property)BlockStateProperties.WATERLOGGED)));
            }
            context.level().setBlock((BlockPos)currentBlockMutable, currentState, 3);
        } else if (incomingBlockState.getBlock() instanceof FenceBlock) {
            BlockState currentState = incomingBlockState.getBlock().defaultBlockState();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                offsetMutable.set((Vec3i)currentBlockMutable).move(direction);
                if (currentChunkPos.x != offsetMutable.getX() >> 4 || currentChunkPos.z != offsetMutable.getZ() >> 4) continue;
                BlockState sideBlock = currentChunk.getBlockState((BlockPos)offsetMutable);
                currentState = currentState.updateShape(direction, sideBlock, (LevelAccessor)context.level(), (BlockPos)currentBlockMutable, (BlockPos)offsetMutable);
            }
            if (currentState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                currentState = (BlockState)currentState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)incomingBlockState.getValue((Property)BlockStateProperties.WATERLOGGED)));
            }
            context.level().setBlock((BlockPos)currentBlockMutable, currentState, 3);
        } else {
            context.level().setBlock((BlockPos)currentBlockMutable, incomingBlockState, 3);
        }
    }
}

