/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.features.configs.MinecartConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MinecartFeature
extends Feature<MinecartConfig> {
    private static final BlockIgnoreProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.STRUCTURE_VOID));
    private final StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setMirror(Mirror.NONE).addProcessor((StructureProcessor)IGNORE_STRUCTURE_VOID).setIgnoreEntities(false);

    public MinecartFeature(Codec<MinecartConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<MinecartConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        if (!context.level().getBlockState(mutable.below()).canOcclude()) {
            return false;
        }
        BlockState worldBlock = context.level().getBlockState((BlockPos)mutable);
        if (((MinecartConfig)context.config()).waterBased ? !worldBlock.getFluidState().is(FluidTags.WATER) : !worldBlock.getFluidState().isEmpty()) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        StructureTemplateManager templatemanager = context.level().getLevel().getServer().getStructureManager();
        Optional template = templatemanager.get(((MinecartConfig)context.config()).nbtPath);
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.warn(((MinecartConfig)context.config()).nbtPath.toString() + " NTB does not exist!");
            return false;
        }
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).getSize().getX() / 2, 0, ((StructureTemplate)template.get()).getSize().getZ() / 2);
        this.structurePlaceSettings.setRotation(Rotation.getRandom((RandomSource)context.random())).setRotationPivot(halfLengths).setIgnoreEntities(false);
        blockpos$Mutable.set((Vec3i)context.origin());
        BlockPos offset = new BlockPos(-((StructureTemplate)template.get()).getSize().getX() / 2, 0, -((StructureTemplate)template.get()).getSize().getZ() / 2);
        ((StructureTemplate)template.get()).placeInWorld((ServerLevelAccessor)context.level(), blockpos$Mutable.offset((Vec3i)offset), blockpos$Mutable.offset((Vec3i)offset), this.structurePlaceSettings, context.random(), 2);
        return true;
    }
}

