/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.setup.registry;

import com.github.jarva.allthearcanistgear.common.items.armor.ArcanistArmorSet;
import com.github.jarva.allthearcanistgear.common.items.book.AddonSpellBook;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.github.jarva.allthearcanistgear.setup.config.ServerConfig;
import com.github.jarva.allthearcanistgear.setup.registry.ArsNouveauRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AddonItemRegistry {
    public static final List<ArcanistArmorSet> ARMOR_SETS = new ArrayList<ArcanistArmorSet>();
    public static final List<ItemRegistryWrapper<? extends Item>> REGISTERED_ITEMS = new ArrayList<ItemRegistryWrapper<? extends Item>>();
    public static final List<ItemRegistryWrapper<? extends Item>> DATAGEN_ITEMS = new ArrayList<ItemRegistryWrapper<? extends Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"allthearcanistgear");
    public static final ArcanistArmorSet ALLTHEMODIUM = AddonItemRegistry.registerArmorSet(ServerConfig.ALLTHEMODIUM_CONFIG, 4, ArsNouveauRegistry.SPELL_FOUR);
    public static final ArcanistArmorSet VIBRANIUM = AddonItemRegistry.registerArmorSet(ServerConfig.VIBRANIUM_CONFIG, 5, ArsNouveauRegistry.SPELL_FIVE);
    public static final ArcanistArmorSet UNOBTAINIUM = AddonItemRegistry.registerArmorSet(ServerConfig.UNOBTAINIUM_CONFIG, 6, ArsNouveauRegistry.SPELL_SIX);
    public static final ItemRegistryWrapper<AddonSpellBook> CREATIVE = AddonItemRegistry.register("creative_spell_book", () -> new AddonSpellBook(UNOBTAINIUM.getConfig(), SpellTier.CREATIVE, 99), false);

    public static ArcanistArmorSet registerArmorSet(ArmorSetConfig config, int tier, SpellTier spellTier) {
        ArcanistArmorSet arcanistArmorSet = new ArcanistArmorSet(config, tier, spellTier);
        ARMOR_SETS.add(arcanistArmorSet);
        return arcanistArmorSet;
    }

    public static <T extends Item> ItemRegistryWrapper<T> register(String name, Supplier<T> item) {
        return AddonItemRegistry.register(name, item, true);
    }

    public static <T extends Item> ItemRegistryWrapper<T> register(String name, Supplier<T> item, boolean dataGen) {
        ItemRegistryWrapper registered = new ItemRegistryWrapper(ITEMS.register(name, item));
        REGISTERED_ITEMS.add((ItemRegistryWrapper<? extends Item>)registered);
        if (dataGen) {
            DATAGEN_ITEMS.add((ItemRegistryWrapper<? extends Item>)registered);
        }
        return registered;
    }
}

