/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.recipes;

import com.github.jarva.allthearcanistgear.setup.registry.AddonIngredientTypeRegistry;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class PerkTierIngredient
implements ICustomIngredient {
    private final int minLevel;
    private final TagKey<Item> tag;
    public static final MapCodec<PerkTierIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(e -> e.tag), (App)Codec.INT.fieldOf("min_level").forGetter(e -> e.minLevel)).apply((Applicative)instance, PerkTierIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PerkTierIngredient> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());

    public PerkTierIngredient(TagKey<Item> tag, int level) {
        this.tag = tag;
        this.minLevel = level;
    }

    public boolean test(ItemStack itemStack) {
        boolean isItem = itemStack.is(this.tag);
        if (!isItem) {
            return false;
        }
        @Nullable ArmorPerkHolder data = (ArmorPerkHolder)itemStack.get((Supplier)DataComponentRegistry.ARMOR_PERKS);
        if (data == null) {
            return false;
        }
        return data.getTier() >= this.minLevel;
    }

    public Stream<ItemStack> getItems() {
        return BuiltInRegistries.ITEM.getOrCreateTag(this.tag).stream().map(ItemStack::new).map(is -> {
            @Nullable ArmorPerkHolder data = (ArmorPerkHolder)is.get((Supplier)DataComponentRegistry.ARMOR_PERKS);
            if (data == null) {
                return null;
            }
            is.set((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)data.setTier(this.minLevel));
            return is;
        }).filter(Objects::nonNull);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return AddonIngredientTypeRegistry.PERK_TIER.get();
    }
}

