/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.items.armor;

import com.github.jarva.allthearcanistgear.common.items.armor.AddonArmorItem;
import com.github.jarva.allthearcanistgear.common.items.book.AddonSpellBook;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.github.jarva.allthearcanistgear.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;

public class ArcanistArmorSet {
    private final ItemRegistryWrapper<AddonArmorItem> head;
    private final ItemRegistryWrapper<AddonArmorItem> chest;
    private final ItemRegistryWrapper<AddonArmorItem> legs;
    private final ItemRegistryWrapper<AddonArmorItem> feet;
    private final ItemRegistryWrapper<SpellBook> spellbook;
    private final String name;
    private final int tier;
    private final ArmorSetConfig config;

    public ArcanistArmorSet(ArmorSetConfig config, int tier, SpellTier spellTier) {
        this.config = config;
        this.name = config.name();
        this.tier = tier;
        this.head = AddonItemRegistry.register(this.name + "_hat", () -> new AddonArmorItem(config, ArmorItem.Type.HELMET, tier));
        this.chest = AddonItemRegistry.register(this.name + "_robes", () -> new AddonArmorItem(config, ArmorItem.Type.CHESTPLATE, tier));
        this.legs = AddonItemRegistry.register(this.name + "_leggings", () -> new AddonArmorItem(config, ArmorItem.Type.LEGGINGS, tier));
        this.feet = AddonItemRegistry.register(this.name + "_boots", () -> new AddonArmorItem(config, ArmorItem.Type.BOOTS, tier));
        this.spellbook = AddonItemRegistry.register(this.name + "_spell_book", () -> new AddonSpellBook(config, spellTier, tier), false);
    }

    public ArmorSetConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    public AddonArmorItem getHat() {
        return (AddonArmorItem)((Object)this.head.get());
    }

    public AddonArmorItem getChest() {
        return (AddonArmorItem)((Object)this.chest.get());
    }

    public AddonArmorItem getLegs() {
        return (AddonArmorItem)((Object)this.legs.get());
    }

    public AddonArmorItem getBoots() {
        return (AddonArmorItem)((Object)this.feet.get());
    }

    public SpellBook getSpellbook() {
        return (SpellBook)this.spellbook.get();
    }

    public AddonArmorItem getArmorFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChest();
            case EquipmentSlot.LEGS -> this.getLegs();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.HEAD -> this.getHat();
            default -> null;
        };
    }
}

