/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.items.armor;

import com.github.jarva.allthearcanistgear.client.renderers.AddonArmorRenderer;
import com.github.jarva.allthearcanistgear.client.renderers.AddonGenericArmorModel;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.github.jarva.allthearcanistgear.setup.registry.AddonArmorMaterialRegistry;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.ITickablePerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.perk.RepairingPerk;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AddonArmorItem
extends ArmorItem
implements GeoItem {
    private final int tier;
    private final GenericModel<AddonArmorItem> model;
    private final ArmorSetConfig config;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static ArmorPerkHolder getPerkHolder(int tier) {
        return new ArmorPerkHolder("", new ArrayList(), tier, new HashMap());
    }

    public AddonArmorItem(ArmorSetConfig config, ArmorItem.Type slot, int tier) {
        super(AddonArmorMaterialRegistry.BASE, slot, ItemsRegistry.defaultItemProperties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).component((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)AddonArmorItem.getPerkHolder(tier)));
        this.tier = tier;
        this.config = config;
        this.model = new AddonGenericArmorModel(config.name()).withEmptyAnim();
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        stack.update((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)AddonArmorItem.getPerkHolder(this.tier), data -> data.setTier(this.tier));
    }

    public ArmorSetConfig getConfig() {
        return this.config;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ArmorPerkHolder data = (ArmorPerkHolder)stack.get((Supplier)DataComponentRegistry.ARMOR_PERKS);
        if (data != null) {
            tooltipComponents.add((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{data.getTier() + 1}).withStyle(ChatFormatting.GOLD));
            data.appendPerkTooltip(tooltipComponents, stack);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.isClientSide()) {
            return;
        }
        if (slotId < 36 || slotId >= 40) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        RepairingPerk.attemptRepair((ItemStack)stack, (LivingEntity)livingEntity);
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
        if (perkHolder == null) {
            return;
        }
        for (PerkInstance instance : perkHolder.getPerkInstances(stack)) {
            IPerk iPerk = instance.getPerk();
            if (!(iPerk instanceof ITickablePerk)) continue;
            ITickablePerk tickablePerk = (ITickablePerk)iPerk;
            tickablePerk.tick(stack, level, livingEntity, instance);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        super.createGeoRenderer(consumer);
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @Nullable
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new AddonArmorRenderer(AddonArmorItem.this.getArmorModel());
                }
                return this.renderer;
            }
        });
    }

    private GeoModel<AddonArmorItem> getArmorModel() {
        return this.model;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack is) {
        ItemAttributeModifiers modifiers = this.config.buildAttributeMap(this);
        for (PerkInstance instance : ((ArmorPerkHolder)is.get((Supplier)DataComponentRegistry.ARMOR_PERKS)).getPerkInstances(is)) {
            modifiers = instance.getPerk().applyAttributeModifiers(modifiers, is, instance.getSlot().value(), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
        }
        return modifiers;
    }
}

