/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.client.renderers;

import com.github.jarva.allthearcanistgear.common.items.armor.AddonArmorItem;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class AddonArmorRenderer
extends GeoArmorRenderer<AddonArmorItem> {
    public AddonArmorRenderer(GeoModel<AddonArmorItem> modelProvider) {
        super(modelProvider);
    }

    public void renderRecursively(PoseStack poseStack, AddonArmorItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.getName().equalsIgnoreCase("armorRightArmSlim") || bone.getName().equalsIgnoreCase("armorLeftArmSlim")) {
            bone.setHidden(true);
        }
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void actuallyRender(PoseStack poseStack, AddonArmorItem animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        Optional slimRight = model.getBone("armorRightArmSlim");
        Optional slimLeft = model.getBone("armorLeftArmSlim");
        slimRight.ifPresent(geoBone -> geoBone.setHidden(true));
        slimLeft.ifPresent(geoBone -> geoBone.setHidden(true));
        model.getBone("armorRightArmSlim").ifPresent(geoBone -> geoBone.setHidden(true));
        model.getBone("armorLeftArmSlim").ifPresent(geoBone -> geoBone.setHidden(true));
        super.actuallyRender(poseStack, (Item)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public ResourceLocation getTextureLocation(AddonArmorItem instance) {
        GeoModel geoModel;
        if (instance != null && (geoModel = this.model) instanceof GenericModel) {
            GenericModel genericModel = (GenericModel)geoModel;
            return genericModel.textLoc;
        }
        return super.getTextureLocation((GeoAnimatable)instance);
    }
}

