/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.AttributeTooltipComponent;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.saveddata.maps.MapId;

public final class TooltipComponents {
    public static final TooltipComponent ITEM_NAME = (itemStack, tooltipContext, tooltipLines, tooltipFlag) -> {
        MapId mapId;
        MutableComponent component = Component.empty().append(itemStack.getHoverName()).withStyle(itemStack.getRarity().color());
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            component.withStyle(ChatFormatting.ITALIC);
        }
        tooltipLines.add(component);
        if (!tooltipFlag.isAdvanced() && !itemStack.has(DataComponents.CUSTOM_NAME) && itemStack.is(Items.FILLED_MAP) && (mapId = (MapId)itemStack.get(DataComponents.MAP_ID)) != null) {
            tooltipLines.add(MapItem.getTooltipForId((MapId)mapId));
        }
    };
    public static final TooltipComponent ADDITIONAL = (itemStack, tooltipContext, tooltipLines, tooltipFlag) -> {
        if (!itemStack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            if (itemStack.has(DataComponents.CONTAINER)) {
                for (ItemStack item : ((ItemContainerContents)itemStack.get(DataComponents.CONTAINER)).nonEmptyItems()) {
                    tooltipLines.add(Component.translatable((String)"container.shulkerBox.itemCount", (Object[])new Object[]{item.getHoverName(), item.getCount()}).withStyle(ChatFormatting.GRAY));
                }
            } else {
                itemStack.getItem().appendHoverText(itemStack, tooltipContext, tooltipLines, tooltipFlag);
            }
        }
    };
    public static final TooltipComponent JUKEBOX_PLAYABLE = TooltipComponent.fromProvider(DataComponents.JUKEBOX_PLAYABLE);
    public static final TooltipComponent TRIM = (itemStack, tooltipContext, tooltipLines, tooltipFlag) -> {
        ArrayList<Component> tmp = new ArrayList<Component>();
        TooltipComponent.fromProvider(DataComponents.TRIM).addToTooltip(itemStack, tooltipContext, tmp, tooltipFlag);
        if (tmp.size() == 3) {
            tooltipLines.add((Component)tmp.get(1));
        } else {
            tooltipLines.addAll(tmp);
        }
    };
    public static final TooltipComponent STORED_ENCHANTMENTS = TooltipComponent.fromProvider(DataComponents.STORED_ENCHANTMENTS);
    public static final TooltipComponent ENCHANTMENTS = TooltipComponent.fromProvider(DataComponents.ENCHANTMENTS);
    public static final TooltipComponent DYED_COLOR = TooltipComponent.fromProvider(DataComponents.DYED_COLOR);
    public static final TooltipComponent LORE = TooltipComponent.fromProvider(DataComponents.LORE);
    public static final TooltipComponent ATTRIBUTE = new AttributeTooltipComponent();
    public static final TooltipComponent UNBREAKABLE = TooltipComponent.fromProvider(DataComponents.UNBREAKABLE);
    public static final TooltipComponent DURABILITY = new TooltipComponent(){

        @Override
        public void addToTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipLines, TooltipFlag tooltipFlag) {
            if (itemStack.isDamaged()) {
                tooltipLines.add((Component)Component.translatable((String)"item.durability", (Object[])new Object[]{itemStack.getMaxDamage() - itemStack.getDamageValue(), itemStack.getMaxDamage()}).withStyle(ChatFormatting.GRAY));
            }
        }

        @Override
        public boolean alwaysUpdate() {
            return true;
        }
    };
    public static final TooltipComponent IDENTIFIER = (itemStack, tooltipContext, tooltipLines, tooltipFlag) -> tooltipLines.add(Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString()).withStyle(ChatFormatting.GRAY));
    public static final TooltipComponent COMPONENT_COUNT = (itemStack, tooltipContext, tooltipLines, tooltipFlag) -> {
        if (!itemStack.getComponents().isEmpty()) {
            tooltipLines.add(Component.translatable((String)"item.components", (Object[])new Object[]{itemStack.getComponents().size()}).withStyle(ChatFormatting.GRAY));
        }
    };
}

