/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import com.google.common.collect.Lists;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TooltipComponentHolder {
    private final TooltipComponent component;
    private final TooltipComponentConfig settings;
    private List<Component> lines;
    private int maxLines = -1;

    public TooltipComponentHolder(TooltipComponent component, TooltipComponentConfig settings) {
        this.component = component;
        this.settings = settings;
    }

    public boolean include() {
        return this.settings.include;
    }

    public int ordering() {
        return this.settings.ordering;
    }

    public int priority() {
        return this.settings.priority;
    }

    public void clear() {
        this.lines = null;
    }

    public void rebuildIfNecessary(ItemStack itemStack, Item.TooltipContext tooltipContext) {
        if (this.lines == null || this.component.alwaysUpdate()) {
            ArrayList tooltipLines = Lists.newArrayList((Object[])new Component[]{CommonComponents.EMPTY});
            TooltipFlag.Default tooltipFlag = this.settings.advancedTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            this.component.addToTooltip(itemStack, tooltipContext, tooltipLines, (TooltipFlag)tooltipFlag);
            ListIterator<Component> iterator = tooltipLines.listIterator();
            while (iterator.hasNext()) {
                PlainTextContents contents;
                Component component2 = (Component)iterator.next();
                ComponentContents componentContents = component2.getContents();
                if (!(componentContents instanceof PlainTextContents) || !(contents = (PlainTextContents)componentContents).text().isBlank()) continue;
                if (!component2.getSiblings().isEmpty()) {
                    iterator.set((Component)component2.getSiblings().getFirst());
                    continue;
                }
                iterator.remove();
            }
            Style style = this.settings.getStyle();
            if (style != Style.EMPTY) {
                tooltipLines.replaceAll(component -> component.copy().withStyle(arg_0 -> ((Style)style).applyTo(arg_0)));
            }
            this.lines = Collections.unmodifiableList(tooltipLines);
        }
    }

    public int subtractLines(int maxLines) {
        this.maxLines = Math.min(this.size(), Math.max(maxLines, 0));
        return maxLines - this.size();
    }

    public List<Component> getLines() {
        return this.getLinesOrThrow().subList(0, this.maxLines);
    }

    public int size() {
        return this.getLinesOrThrow().size();
    }

    private List<Component> getLinesOrThrow() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines;
    }
}

