/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class GraveGuardianArmorLayer<T extends GraveGuardian, M extends SkeletonModel<T>>
extends HumanoidArmorLayer<T, M, SkeletonModel<T>> {
    private final SkeletonModel<T> innerModel;
    private final SkeletonModel<T> outerModel;
    private final ItemInHandRenderer itemInHandRenderer;
    private final TextureAtlas armorTrimAtlas;
    private static final Supplier<ItemStack> HALLOWEEN_HELMET = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.JACK_O_LANTERN));
    private static final Supplier<ItemStack> CHRISTMAS_HELMET = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.christmas_hat));
    private static final Supplier<ItemStack> EASTER_MASK = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.rabbit_mask));

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, EntityRendererProvider.Context context) {
        this(parent, new SkeletonModel(context.bakeLayer(ModelLayers.STRAY_INNER_ARMOR)), new SkeletonModel(context.bakeLayer(ModelLayers.STRAY_OUTER_ARMOR)), context);
    }

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, SkeletonModel<T> innerModel, SkeletonModel<T> outerModel, EntityRendererProvider.Context context) {
        super(parent, innerModel, outerModel, context.getModelManager());
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.itemInHandRenderer = context.getItemInHandRenderer();
        this.armorTrimAtlas = context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, T graveGuardian, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.CHEST, light, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.LEGS, light, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.FEET, light, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.HEAD, light, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T graveGuardian, EquipmentSlot slot, int light, SkeletonModel<T> model) {
        ItemStack specialHelmet;
        if (slot == EquipmentSlot.HEAD && !(specialHelmet = this.getSpecialHelmet()).isEmpty()) {
            this.renderSpecialHelmet(poseStack, bufferSource, graveGuardian, specialHelmet);
            return;
        }
        ItemStack stack = graveGuardian.getItemBySlot(slot);
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            if (armor.getEquipmentSlot() == slot) {
                float b;
                float g;
                float r;
                ((SkeletonModel)this.getParentModel()).copyPropertiesTo(model);
                this.setPartVisibility((HumanoidModel)model, slot);
                Model armorModel = this.getArmorModelHook((LivingEntity)graveGuardian, stack, slot, (HumanoidModel)model);
                boolean useInnerModel = slot == EquipmentSlot.LEGS;
                ArmorMaterial armorMaterial = (ArmorMaterial)armor.getMaterial().value();
                if (TimeHelper.isDateAroundHalloween()) {
                    r = 1.0f;
                    g = 0.4f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else if (TimeHelper.isDateAroundChristmas()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                } else if (TimeHelper.isDateAroundEaster()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 1.0f;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                int arbg = FastColor.ARGB32.opaque((int)(0xFF000000 | Mth.floor((float)(r * 255.0f)) << 16 | Mth.floor((float)(g * 255.0f)) << 8 | Mth.floor((float)(b * 255.0f))));
                for (ArmorMaterial.Layer layer : armorMaterial.layers()) {
                    this.renderModel(poseStack, bufferSource, light, armorModel, arbg, ClientHooks.getArmorTexture(graveGuardian, (ItemStack)stack, (ArmorMaterial.Layer)layer, (boolean)useInnerModel, (EquipmentSlot)slot));
                }
                ArmorTrim armorTrim = this.getArmorTrim();
                if (armorTrim != null) {
                    this.renderTrim((Holder<ArmorMaterial>)armor.getMaterial(), poseStack, bufferSource, light, armorTrim, (Model)model, useInnerModel);
                }
            }
        } else if (slot == EquipmentSlot.HEAD && stack.is(Items.JACK_O_LANTERN)) {
            this.renderSpecialHelmet(poseStack, bufferSource, graveGuardian, stack);
        }
    }

    @Nullable
    private ArmorTrim getArmorTrim() {
        RegistryAccess registryAccess = Optional.ofNullable(Minecraft.getInstance().level).map(Level::registryAccess).orElse(null);
        if (registryAccess != null) {
            ResourceKey trimMaterialRK;
            return new ArmorTrim((Holder)registryAccess.lookupOrThrow(Registries.TRIM_MATERIAL).getOrThrow(trimMaterialRK), (Holder)registryAccess.lookupOrThrow(Registries.TRIM_PATTERN).getOrThrow(switch (TimeHelper.getSpecialEvent()) {
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    trimMaterialRK = TrimMaterials.QUARTZ;
                    yield TrimPatterns.DUNE;
                }
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    trimMaterialRK = TrimMaterials.COPPER;
                    yield TrimPatterns.SILENCE;
                }
                case TimeHelper.SpecialEvent.EASTER, TimeHelper.SpecialEvent.APRIL_FOOLS -> {
                    trimMaterialRK = TrimMaterials.AMETHYST;
                    yield TrimPatterns.COAST;
                }
                default -> {
                    trimMaterialRK = TrimMaterials.GOLD;
                    yield TrimPatterns.WARD;
                }
            }));
        }
        return null;
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, Model armorModel, int color, ResourceLocation armorTexture) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)armorTexture));
        armorModel.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, color);
    }

    private void renderTrim(Holder<ArmorMaterial> armorMaterialHolder, PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorTrim armorTrim, Model model, boolean useInnerModel) {
        TextureAtlasSprite sprite = this.armorTrimAtlas.getSprite(useInnerModel ? armorTrim.innerTexture(armorMaterialHolder) : armorTrim.outerTexture(armorMaterialHolder));
        VertexConsumer vertexconsumer = sprite.wrap(bufferSource.getBuffer(Sheets.armorTrimsSheet((boolean)false)));
        model.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
    }

    private void renderSpecialHelmet(PoseStack poseStack, MultiBufferSource bufferSource, T graveGuardian, ItemStack specialHelmet) {
        poseStack.pushPose();
        ((SkeletonModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
        CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)false);
        this.itemInHandRenderer.renderItem(graveGuardian, specialHelmet, ItemDisplayContext.HEAD, false, poseStack, bufferSource, 0xF000F0);
        poseStack.popPose();
    }

    private SkeletonModel<T> getArmorModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? this.innerModel : this.outerModel;
    }

    private ItemStack getSpecialHelmet() {
        return TimeHelper.isDateAroundHalloween() ? HALLOWEEN_HELMET.get() : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_HELMET.get() : (TimeHelper.isDateAroundEaster() ? EASTER_MASK.get() : ItemStack.EMPTY));
    }
}

