/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.google.common.reflect.Reflection;
import net.minecraft.core.registries.Registries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModPaintings;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModPotions;
import ovh.corail.tombstone.registry.ModSerializers;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.MOD)
public class Registration {
    @SubscribeEvent
    public static void onRegistration(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            ModBlocks.onRegisterBlocks(event);
        } else if (event.getRegistryKey().equals(Registries.ITEM)) {
            ModBlocks.onRegisterBlockItems(event);
            ModItems.onRegister(event);
            Reflection.initialize((Class[])new Class[]{ModTags.class, ModEnchantments.class});
        } else if (event.getRegistryKey().equals(Registries.BLOCK_ENTITY_TYPE)) {
            ModBlocks.onRegisterBlockEntityTypes(event);
        } else if (event.getRegistryKey().equals(Registries.MOB_EFFECT)) {
            ModEffects.onRegister();
        } else if (event.getRegistryKey().equals(Registries.POTION)) {
            ModPotions.onRegister();
        } else if (event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            ModEntities.onRegister(event);
        } else if (event.getRegistryKey().equals(Registries.PAINTING_VARIANT)) {
            ModPaintings.onRegister(event);
        } else if (event.getRegistryKey().equals(Registries.PARTICLE_TYPE)) {
            ModParticleTypes.onRegister(event);
        } else if (event.getRegistryKey().equals(Registries.SOUND_EVENT)) {
            ModSounds.registerSounds(event);
        } else if (event.getRegistryKey().equals(Registries.RECIPE_SERIALIZER)) {
            ModSerializers.onRegister(event);
        } else if (event.getRegistryKey().equals(PerkRegistry.PERK_RESOURCE_KEY)) {
            ModPerks.onRegister(event);
        } else if (event.getRegistryKey().equals(Registries.LOOT_FUNCTION_TYPE)) {
            ModLootFunctions.onRegisterFunctions(event);
        } else if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
            ModTabs.onRegisterCreativeTab(event);
        } else if (event.getRegistryKey().equals(Registries.TRIGGER_TYPE)) {
            ModTriggers.onRegisterTriggers(event);
        } else if (event.getRegistryKey().equals(Registries.CUSTOM_STAT)) {
            ModStats.onRegisterStats(event);
        } else if (event.getRegistryKey().equals(Registries.DATA_COMPONENT_TYPE)) {
            ModDataComponents.onRegister(event);
        } else if (event.getRegistryKey().equals(Registries.BLOCK_TYPE)) {
            ModBlocks.onRegisterBlockTypes(event);
        } else if (event.getRegistryKey().equals(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE)) {
            ModEnchantments.onRegisterEnchantmentEntityEffect(event);
        }
    }

    @SubscribeEvent
    public static void onRegisterAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.grave_guardian, GraveGuardian.createAttributes());
        event.put(ModEntities.spectral_wolf, SpectralWolf.buildAttributes());
    }
}

