/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

public final class ModTabs {
    public static final ResourceLocation TAB_ID = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"creative_tab");

    public static void onRegisterCreativeTab(RegisterEvent event) {
        event.register(Registries.CREATIVE_MODE_TAB, TAB_ID, () -> CreativeModeTab.builder().title((Component)Component.literal((String)"Corail Tombstone")).icon(() -> ItemBlockGrave.createDecorativeStack(GraveModel.TOMBSTONE, 0)).displayItems((params, output) -> {
            Arrays.stream(GraveModel.values()).forEach(graveModel -> IntStream.range(0, BlockGraveMarble.MarbleType.values().length).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(graveModel, textureId)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0)));
            output.accept((ItemLike)ModBlocks.dark_marble);
            output.accept((ItemLike)ModBlocks.white_marble);
            output.accept((ItemLike)ModBlocks.blue_marble);
            output.accept((ItemLike)ModBlocks.green_marble);
            output.accept((ItemLike)ModBlocks.carmin_marble);
            output.accept((ItemLike)ModBlocks.dark_marble_slab);
            output.accept((ItemLike)ModBlocks.white_marble_slab);
            output.accept((ItemLike)ModBlocks.blue_marble_slab);
            output.accept((ItemLike)ModBlocks.green_marble_slab);
            output.accept((ItemLike)ModBlocks.carmin_marble_slab);
            output.accept((ItemLike)ModBlocks.dark_marble_stairs);
            output.accept((ItemLike)ModBlocks.white_marble_stairs);
            output.accept((ItemLike)ModBlocks.blue_marble_stairs);
            output.accept((ItemLike)ModBlocks.green_marble_stairs);
            output.accept((ItemLike)ModBlocks.carmin_marble_stairs);
            output.accept((ItemLike)ModBlocks.dark_marble_wall);
            output.accept((ItemLike)ModBlocks.white_marble_wall);
            output.accept((ItemLike)ModBlocks.blue_marble_wall);
            output.accept((ItemLike)ModBlocks.green_marble_wall);
            output.accept((ItemLike)ModBlocks.carmin_marble_wall);
            ModItems.ITEMS.forEach(item -> {
                if (item instanceof ITab) {
                    ((ITab)item).fillItemCategory(output);
                } else {
                    output.accept((ItemLike)item);
                }
            });
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.earthly_garden, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.bait, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.frostbite, 4));
            output.accept(EffectHelper.createMagicArrows(1, (Holder<MobEffect>)MobEffects.DARKNESS, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.discretion, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.restoration, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.weaver_walk, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.giant_strength, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.little_world, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.incurable, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.decrepitude, 4));
            output.accept(EffectHelper.createMagicArrows(1, ModEffects.projectile_reflection, 4));
            output.accept(EffectHelper.createCursedArrows(1));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.spectral));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.spectral));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.spectral));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.earthly_garden));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.bait));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.frostbite));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.darkness));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.discretion));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.restoration));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.weaver_walk));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.giant_strength));
            output.accept(PotionContents.createItemStack((Item)Items.POTION, ModPotions.little_world));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.earthly_garden));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.bait));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.frostbite));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.darkness));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.discretion));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.restoration));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.weaver_walk));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.giant_strength));
            output.accept(PotionContents.createItemStack((Item)Items.SPLASH_POTION, ModPotions.little_world));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.earthly_garden));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.bait));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.frostbite));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.darkness));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.discretion));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.restoration));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.weaver_walk));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.giant_strength));
            output.accept(PotionContents.createItemStack((Item)Items.LINGERING_POTION, ModPotions.little_world));
            ModTabs.fillWithEnchantedBook(params, output);
        }).withSearchBar().build());
    }

    private static void fillWithEnchantedBook(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        params.holders().lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(ench -> ench.key().location().getNamespace().equals("tombstone")).forEach(enchantmentHolder -> {
            items.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentHolder, 1)));
            int maxLevel = ((Enchantment)enchantmentHolder.value()).getMaxLevel();
            for (int level = 5; level <= maxLevel; level += 5) {
                items.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentHolder, level)));
            }
            if (maxLevel > 1 && maxLevel % 5 != 0) {
                items.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantmentHolder, maxLevel)));
            }
        });
    }
}

