/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;

public class ModDataComponents {
    public static DataComponentType<Boolean> ENCHANTED = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> ANCIENT = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> TARGET_FOUND = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> IS_LOOT_NO_SYNC = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_0 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_1 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_2 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_3 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_4 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> VOODOO_POPPET_PROT_5 = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Integer> USE_COUNT = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Integer> STORED_XP = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Long> COOLDOWN_TIME = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Long> COOLDOWN_TIME_NO_SYNC = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<String> ENGRAVED_NAME = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<String> ENTITY_TYPE = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<String> CAPTURABLE_ENTITY_TYPE = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<String> LOST_TABLET_ID = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Float> HEALTH = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Float> HEALTH_MAX = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Integer> MODEL_TEXTURE = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Short> MODEL_COLOR = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Short> LOST_TABLET_TYPE = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Short> LOST_TABLET_ROLL_NO_SYNC = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<GlobalPos> LOCATION = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Integer> COLOR = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<UUID> UNIQUE_IDENTIFIER_NO_SYNC = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<String> EFFECT_ID = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Short> EFFECT_AMPLIFIER = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> ENCHANTED_ARROW = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> CURSED_ARROW = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<CompoundTag> ADDITIONAL_DATA = (DataComponentType)Helper.unsafeNullCast();
    public static DataComponentType<Boolean> SOULBOUND = (DataComponentType)Helper.unsafeNullCast();

    public static void onRegister(RegisterEvent event) {
        ENCHANTED = ModDataComponents.register("tb_enchanted", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        ANCIENT = ModDataComponents.register("tb_ancient", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        TARGET_FOUND = ModDataComponents.register("tb_target_found", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        IS_LOOT_NO_SYNC = ModDataComponents.register("tb_is_loot", c -> c.persistent((Codec)Codec.BOOL));
        VOODOO_POPPET_PROT_0 = ModDataComponents.register("tb_voodoo_poppet_prot_0", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        VOODOO_POPPET_PROT_1 = ModDataComponents.register("tb_voodoo_poppet_prot_1", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        VOODOO_POPPET_PROT_2 = ModDataComponents.register("tb_voodoo_poppet_prot_2", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        VOODOO_POPPET_PROT_3 = ModDataComponents.register("tb_voodoo_poppet_prot_3", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        VOODOO_POPPET_PROT_4 = ModDataComponents.register("tb_voodoo_poppet_prot_4", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        VOODOO_POPPET_PROT_5 = ModDataComponents.register("tb_voodoo_poppet_prot_5", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        USE_COUNT = ModDataComponents.register("tb_use_count", c -> c.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
        STORED_XP = ModDataComponents.register("tb_stored_xp", c -> c.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
        COOLDOWN_TIME = ModDataComponents.register("tb_cooldown_time", c -> c.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
        COOLDOWN_TIME_NO_SYNC = ModDataComponents.register("tb_cooldown_time_no_sync", c -> c.persistent((Codec)Codec.LONG));
        ENGRAVED_NAME = ModDataComponents.register("tb_engraved_name", c -> c.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
        ENTITY_TYPE = ModDataComponents.register("tb_entity_type", c -> c.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
        CAPTURABLE_ENTITY_TYPE = ModDataComponents.register("tb_capturable_entity_type", c -> c.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
        LOST_TABLET_ID = ModDataComponents.register("tb_lost_tablet_id", c -> c.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
        HEALTH = ModDataComponents.register("tb_health", c -> c.persistent((Codec)Codec.FLOAT).networkSynchronized(ByteBufCodecs.FLOAT));
        HEALTH_MAX = ModDataComponents.register("tb_health_max", c -> c.persistent((Codec)Codec.FLOAT).networkSynchronized(ByteBufCodecs.FLOAT));
        MODEL_TEXTURE = ModDataComponents.register("tb_model_texture", c -> c.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
        MODEL_COLOR = ModDataComponents.register("tb_model_color", c -> c.persistent((Codec)Codec.SHORT).networkSynchronized(ByteBufCodecs.SHORT));
        LOST_TABLET_TYPE = ModDataComponents.register("tb_lost_tablet_type", c -> c.persistent((Codec)Codec.SHORT).networkSynchronized(ByteBufCodecs.SHORT));
        LOST_TABLET_ROLL_NO_SYNC = ModDataComponents.register("tb_lost_tablet_roll", c -> c.persistent((Codec)Codec.SHORT));
        LOCATION = ModDataComponents.register("tb_location", c -> c.persistent(GlobalPos.CODEC).networkSynchronized(GlobalPos.STREAM_CODEC));
        COLOR = ModDataComponents.register("tb_color", c -> c.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
        UNIQUE_IDENTIFIER_NO_SYNC = ModDataComponents.register("tb_unique_identifier", c -> c.persistent(UUIDUtil.CODEC));
        EFFECT_ID = ModDataComponents.register("tb_effect_id", c -> c.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
        EFFECT_AMPLIFIER = ModDataComponents.register("tb_effect_amplifier", c -> c.persistent((Codec)Codec.SHORT).networkSynchronized(ByteBufCodecs.SHORT));
        ENCHANTED_ARROW = ModDataComponents.register("tb_enchanted_arrow", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        CURSED_ARROW = ModDataComponents.register("tb_cursed_arrow", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        ADDITIONAL_DATA = ModDataComponents.register("tb_additional_data", c -> c.persistent(CompoundTag.CODEC));
        SOULBOUND = ModDataComponents.register("tb_soulbound", c -> c.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    }

    private static <T> DataComponentType<T> register(String name, UnaryOperator<DataComponentType.Builder<T>> factory) {
        return (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), (Object)((DataComponentType.Builder)factory.apply(DataComponentType.builder())).build());
    }

    public static CompoundTag getCompoundTag(ItemStack stack) {
        return Optional.ofNullable((CompoundTag)stack.get(ADDITIONAL_DATA)).orElseGet(() -> {
            CompoundTag compoundTag = new CompoundTag();
            stack.set(ADDITIONAL_DATA, (Object)compoundTag);
            return compoundTag;
        });
    }

    public static Location getLocation(ItemStack stack) {
        return new Location((GlobalPos)stack.getOrDefault(LOCATION, (Object)Location.ORIGIN.asGlobalPos()));
    }

    public static void setLocation(ItemStack stack, Location location) {
        if (!location.isOrigin()) {
            stack.set(LOCATION, (Object)location.asGlobalPos());
        }
    }

    public static int getTimer(long actualTime, ItemStack stack, DataComponentType<Long> dataComponent, int limit) {
        long endTime = (Long)stack.getOrDefault(dataComponent, (Object)0L);
        if (endTime > 0L) {
            long leftTime = endTime - actualTime;
            if (leftTime > 0L) {
                if (leftTime > (long)limit) {
                    stack.set(dataComponent, (Object)(actualTime + (long)limit));
                    leftTime = limit;
                }
                return (int)leftTime;
            }
            stack.remove(dataComponent);
        }
        return 0;
    }

    public static boolean hasTimer(long actualTime, ItemStack stack, DataComponentType<Long> dataComponent, int limit) {
        return ModDataComponents.getTimer(actualTime, stack, dataComponent, limit) > 0;
    }

    public static void setTimer(ItemStack stack, DataComponentType<Long> dataComponent, long endTime) {
        stack.set(COOLDOWN_TIME, (Object)endTime);
    }

    private static DataComponentType<Boolean> getVoodooPoppetProt(int id) {
        return switch (id) {
            case 1 -> VOODOO_POPPET_PROT_1;
            case 2 -> VOODOO_POPPET_PROT_2;
            case 3 -> VOODOO_POPPET_PROT_3;
            case 4 -> VOODOO_POPPET_PROT_4;
            case 5 -> VOODOO_POPPET_PROT_5;
            default -> VOODOO_POPPET_PROT_0;
        };
    }

    public static void addVoodooPoppetProt(ItemStack stack, int id) {
        stack.set(ModDataComponents.getVoodooPoppetProt(id), (Object)true);
    }

    public static boolean hasVoodooPoppetProt(ItemStack stack, int id) {
        return (Boolean)stack.getOrDefault(ModDataComponents.getVoodooPoppetProt(id), (Object)false);
    }

    public static void removeVoodooPoppetProt(ItemStack stack, int id) {
        stack.remove(ModDataComponents.getVoodooPoppetProt(id));
    }
}

