/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

public record SMessageResetPerk(Vec3 vec, Direction direction, BlockPos pos, boolean isInside) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<SMessageResetPerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"reset_perk"));
    static StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf buf) {
            return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void encode(ByteBuf buf, Vec3 posVec) {
            buf.writeDouble(posVec.x);
            buf.writeDouble(posVec.y);
            buf.writeDouble(posVec.z);
        }
    };
    static final StreamCodec<ByteBuf, SMessageResetPerk> STREAM_CODEC = StreamCodec.composite(VEC3, SMessageResetPerk::vec, (StreamCodec)Direction.STREAM_CODEC, SMessageResetPerk::direction, (StreamCodec)BlockPos.STREAM_CODEC, SMessageResetPerk::pos, (StreamCodec)ByteBufCodecs.BOOL, SMessageResetPerk::isInside, SMessageResetPerk::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(SMessageResetPerk msg, IPayloadContext ctx) {
        BlockState state;
        BlockHitResult result;
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (player.getMainHandItem().is((Item)ModItems.ankh_of_prayer) && (result = new BlockHitResult(msg.vec, msg.direction, msg.pos, msg.isInside)).distanceTo((Entity)player) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = player.level().getBlockState(msg.pos)).getBlock())) {
            state.useItemOn(player.getMainHandItem(), player.level(), (Player)player, InteractionHand.MAIN_HAND, result);
        }
    }
}

