/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessagePlayerPreference(PlayerPreference playerPreference, boolean isLogin) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<SMessagePlayerPreference> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_preference"));
    static StreamCodec<ByteBuf, PlayerPreference> PLAYER_PREFERENCE = new StreamCodec<ByteBuf, PlayerPreference>(){

        public PlayerPreference decode(ByteBuf buf) {
            return PlayerPreference.fromBytes(buf);
        }

        public void encode(ByteBuf buf, PlayerPreference playerPreference) {
            PlayerPreference.toBytes(playerPreference, buf);
        }
    };
    static final StreamCodec<ByteBuf, SMessagePlayerPreference> STREAM_CODEC = StreamCodec.composite(PLAYER_PREFERENCE, SMessagePlayerPreference::playerPreference, (StreamCodec)ByteBufCodecs.BOOL, SMessagePlayerPreference::isLogin, SMessagePlayerPreference::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(SMessagePlayerPreference msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        PlayerPreference oldPlayerPreference = PlayerPreference.get(player);
        PlayerPreference.set(player, msg.playerPreference);
        if (!msg.isLogin && !msg.playerPreference.hasSameFavoriteGrave(oldPlayerPreference)) {
            ModTriggers.choose_grave_type.trigger(player);
        }
    }
}

