/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageCombination(CombineType combineType) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<SMessageCombination> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"combination"));
    static final StreamCodec<ByteBuf, SMessageCombination> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.UNSIGNED_SHORT, msg -> msg.combineType.ordinal(), combineTypeId -> new SMessageCombination(CombineType.values()[combineTypeId]));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(SMessageCombination msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (player != null && player.isCreative()) {
            switch (msg.combineType().ordinal()) {
                case 2: {
                    ModTriggers.combine_in_inventory.trigger(player);
                    ModTriggers.impregnated_receptacle.trigger(player);
                    break;
                }
                case 1: {
                    ModTriggers.combine_in_inventory.trigger(player);
                    ModTriggers.color_smoke_ball.trigger(player);
                    break;
                }
                default: {
                    ModTriggers.combine_in_inventory.trigger(player);
                }
            }
        }
    }

    public static enum CombineType {
        COMBINE_IN_INVENTORY,
        COLOR_SMOKE_BALL,
        RECEPTACLE_OF_FAMILIAR;

    }
}

