/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.capability.FriendlyAnimalHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageServant(int entityId, UUID uuid, boolean isServant) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageServant> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"servant"));
    static StreamCodec<ByteBuf, UUID> UUID = new StreamCodec<ByteBuf, UUID>(){

        public UUID decode(ByteBuf buf) {
            return ((FriendlyByteBuf)buf).readUUID();
        }

        public void encode(ByteBuf buf, UUID uuid) {
            ((FriendlyByteBuf)buf).writeUUID(uuid);
        }
    };
    static final StreamCodec<ByteBuf, CMessageServant> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CMessageServant::entityId, UUID, CMessageServant::uuid, (StreamCodec)ByteBufCodecs.BOOL, CMessageServant::isServant, CMessageServant::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageServant msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).ifPresent(entity -> {
            if (msg.isServant) {
                if (ServantUndeadHandler.hasCapability(entity)) {
                    ServantUndeadHandler.setOwnerId(entity, msg.uuid);
                }
            } else if (FriendlyAnimalHandler.hasCapability(entity)) {
                FriendlyAnimalHandler.setOwnerId(entity, msg.uuid);
            }
        });
    }
}

