/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;

public record CMessageCooldown(CooldownType cooldownType, long worldTime) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageCooldown> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"cooldown"));
    static StreamCodec<ByteBuf, CooldownType> COOLDOWN_TYPE = new StreamCodec<ByteBuf, CooldownType>(){

        public CooldownType decode(ByteBuf buf) {
            return CooldownType.values()[buf.readByte() & 0xFF];
        }

        public void encode(ByteBuf buf, CooldownType cooldownType) {
            buf.writeByte(cooldownType.ordinal());
        }
    };
    static final StreamCodec<ByteBuf, CMessageCooldown> STREAM_CODEC = StreamCodec.composite(COOLDOWN_TYPE, CMessageCooldown::cooldownType, (StreamCodec)ByteBufCodecs.VAR_LONG, CMessageCooldown::worldTime, CMessageCooldown::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageCooldown msg, IPayloadContext ctx) {
        CooldownHandler.INSTANCE.updateClientCooldown(msg.cooldownType, msg.worldTime);
    }
}

