/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.config.SharedConfigTombstone;

public record CMessageConfig(BitSet boolConfigs, int[] intConfigs) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageConfig> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"config"));
    static StreamCodec<ByteBuf, BitSet> BITSET = new StreamCodec<ByteBuf, BitSet>(){

        public BitSet decode(ByteBuf buf) {
            return BitSet.valueOf(((FriendlyByteBuf)buf).readByteArray());
        }

        public void encode(ByteBuf buf, BitSet boolConfigs) {
            ((FriendlyByteBuf)buf).writeByteArray(boolConfigs.toByteArray());
        }
    };
    static StreamCodec<ByteBuf, int[]> INT_ARRAY = new StreamCodec<ByteBuf, int[]>(){

        public int[] decode(ByteBuf buf) {
            return ((FriendlyByteBuf)buf).readVarIntArray();
        }

        public void encode(ByteBuf buf, int[] intConfigs) {
            ((FriendlyByteBuf)buf).writeVarIntArray(intConfigs);
        }
    };
    static final StreamCodec<ByteBuf, CMessageConfig> STREAM_CODEC = StreamCodec.composite(BITSET, CMessageConfig::boolConfigs, INT_ARRAY, CMessageConfig::intConfigs, CMessageConfig::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageConfig msg, IPayloadContext ctx) {
        SharedConfigTombstone.updateConfig(msg.boolConfigs, msg.intConfigs);
    }
}

