/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModTriggers;

public class TriggerCatMorningFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"trigger_cat_morning");
    public static final MapCodec<TriggerCatMorningFunction> CODEC = RecordCodecBuilder.mapCodec(b -> TriggerCatMorningFunction.commonFields((RecordCodecBuilder.Instance)b).apply((Applicative)b, TriggerCatMorningFunction::new));

    protected TriggerCatMorningFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<TriggerCatMorningFunction> getType() {
        return ModLootFunctions.TRIGGER_CAT_MORNING;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Cat cat;
        Object object;
        if (stack.is((Item)ModItems.grave_dust) && (object = context.getParam(LootContextParams.THIS_ENTITY)) instanceof Cat && (cat = (Cat)object).getOwnerUUID() != null) {
            Optional.ofNullable(cat.getServer()).map(MinecraftServer::getPlayerList).map(pl -> pl.getPlayer(cat.getOwnerUUID())).ifPresent(ModTriggers.grave_dust_from_cat_morning::trigger);
        }
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new TriggerCatMorningFunction(this.getConditions());
        }
    }
}

