/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.combine.CombineUpgrade;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DamageCategory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final int LIMIT_VALID = DamageCategory.LIGHT.ordinal() + 1;

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().stacksTo(1).fireResistant(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
        this.withCombineInfo();
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        List<DamageCategory> damageTypes = this.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageCategory)((Object)d))).toList();
        damageTypes.forEach(d -> tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + "." + d.getSerializedName())).withStyle(StyleType.TOOLTIP_ITEM)));
        boolean enchanted = this.isEnchanted(stack);
        this.addItemUse(tooltip, enchanted ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
        if (enchanted) {
            ProxyHelper.getClientPlayer().ifPresent(player -> ModPerks.witch_doctor.getCurrentBonusInfo(EntityHelper.getPerkLevelWithBonus(player, ModPerks.witch_doctor)).forEach(info -> tooltip.add((Component)info.copy().withStyle(StyleType.INFO))));
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
            ItemStack enchantedVoodooPoppet = new ItemStack((ItemLike)this);
            this.setRandomProtections(enchantedVoodooPoppet, LIMIT_VALID).set(ModDataComponents.ENCHANTED, (Object)true);
            toAdd.accept(enchantedVoodooPoppet);
        }
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.plainCopy()).setStyle(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.is((Item)this) && (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (!this.isEnchanted(stack) && this.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageCategory)((Object)p)))) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getText(new Object[0]));
    }

    public ItemStack createWithRandomProtections(int count) {
        ItemStack stack = this.setRandomProtections(new ItemStack((ItemLike)this), count);
        stack.set(ModDataComponents.ENCHANTED, (Object)true);
        return stack;
    }

    public Stream<DamageCategory> getValidDamageTypes() {
        return Arrays.stream(DamageCategory.values(), 0, LIMIT_VALID);
    }

    public ItemStack addProtection(ItemStack stack, DamageCategory damageType) {
        if (stack.is((Item)this) && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            ModDataComponents.addVoodooPoppetProt(stack, damageType.ordinal());
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, DamageCategory damageType) {
        return stack.is((Item)this) && ModDataComponents.hasVoodooPoppetProt(stack, damageType.ordinal());
    }

    public boolean preventDeath(ServerPlayer player, DamageSource source) {
        DamageCategory damageType = this.getProtection(source);
        if (damageType == null) {
            return false;
        }
        ItemStack voodooPoppet = InventoryHelper.findFirstInInventory((Player)player, p -> this.canPreventDeath((ItemStack)p, damageType));
        if (voodooPoppet.isEmpty()) {
            return false;
        }
        int chance = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.witch_doctor) * 10;
        if (Helper.RANDOM.nextInt(100) >= chance) {
            ModDataComponents.removeVoodooPoppetProt(voodooPoppet, damageType.ordinal());
            if (this.getValidDamageTypes().noneMatch(d -> this.hasProtection(voodooPoppet, (DamageCategory)((Object)d)))) {
                voodooPoppet.shrink(1);
            }
        }
        LangKey.sendSystemMessage((Player)player, (Component)Component.translatable((String)("tombstone.message.prevent_death." + damageType.getSerializedName())), StyleType.MESSAGE_SPECIAL);
        ModTriggers.prevent_death.get((Object)damageType).trigger(player);
        return true;
    }

    public boolean canPreventDeath(ItemStack stack, DamageCategory damageType) {
        return this.isEnchanted(stack) && ModDataComponents.hasVoodooPoppetProt(stack, damageType.ordinal());
    }

    @Nullable
    public DamageCategory getProtection(DamageSource srcDmg) {
        DamageCategory damageType = DamageCategory.of(srcDmg);
        return this.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        List<DamageCategory> damages = this.getValidDamageTypes().collect(Collectors.toList());
        if (count < LIMIT_VALID) {
            IntStream.range(0, LIMIT_VALID - count).forEach(i -> damages.remove(Helper.RANDOM.nextInt(damages.size())));
        }
        damages.forEach(d -> this.addProtection(stack, (DamageCategory)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        this.setRandomProtections(stack, Helper.RANDOM.nextInt(LIMIT_VALID) + 1).set(ModDataComponents.ENCHANTED, (Object)true);
        return stack;
    }

    @Nullable
    public DamageCategory getProtection(ItemStack ingredient) {
        return ModTags.Items.VOODOO_POPPET_INGREDIENT_BY_TYPE.entrySet().stream().filter(entry -> ingredient.is((TagKey)entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public boolean overrideOtherStackedOnMe(ItemStack voodooPoppet, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        DamageCategory damageType;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && voodooPoppet.is((Item)this) && (damageType = this.getProtection(added)) != null) {
            MutableComponent errorMessage;
            Object object = this.isEnchanted(voodooPoppet) ? LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]) : (errorMessage = this.hasProtection(voodooPoppet, damageType) ? LangKey.MESSAGE_VOODOO_POPPET_ALREADY_PROTECTED.getText(new Object[0]) : null);
            if (errorMessage != null) {
                if (player.level().isClientSide) {
                    ProxyHelper.addToast(added.copy(), new ItemStack((ItemLike)this), (Component)errorMessage);
                }
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    ModDataComponents.addVoodooPoppetProt(voodooPoppet, damageType.ordinal());
                    added.shrink(1);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COMBINE_IN_INVENTORY));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return this.isEnchanted(stack) ? Optional.empty() : Optional.of(new TooltipCombineUpgrade((CombineUpgrade[])ModTags.Items.VOODOO_POPPET_INGREDIENT_BY_TYPE.entrySet().stream().map(entry -> new CombineUpgrade((TagKey<Item>)((TagKey)entry.getValue()), !ModItems.voodoo_poppet.hasProtection(stack, (DamageCategory)((Object)((Object)entry.getKey()))))).toArray(CombineUpgrade[]::new)));
    }
}

