/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.blockEntity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemGraveKey
extends ItemGraveMagic
implements ICombineCraft {
    private TooltipComponent tooltip;

    public ItemGraveKey() {
        super("grave_key", ItemGraveKey.getBuilder().component(ModDataComponents.SOULBOUND, (Object)true), () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
        this.withCombineInfo();
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        String id = this.isEnchanted(stack) ? "2" : "1";
        this.addItemDesc(tooltip, id, new Object[0]);
        this.addItemDesc(tooltip, "3", new Object[0]);
        this.addItemPosition(tooltip, this.getTombPos(stack));
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, context, tooltip);
    }

    public boolean overrideOtherStackedOnMe(ItemStack graveKey, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        CombineCraft combine;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && graveKey.is((Item)this) && (combine = this.getCombination(added)) != null) {
            if (((Boolean)SharedConfigTombstone.magic_item.disableEnchantedGraveKeyRecipe.get()).booleanValue()) {
                if (player.level().isClientSide) {
                    ProxyHelper.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_CRAFT_ENCHANTED_GRAVE_KEY_DISABLED.getText(new Object[0]));
                }
            } else if (this.isEnchanted(graveKey)) {
                if (player.level().isClientSide) {
                    ProxyHelper.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]));
                }
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    graveKey.set(ModDataComponents.ENCHANTED, (Object)true);
                    added.shrink(1);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COMBINE_IN_INVENTORY));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = this.createTooltip();
        }
        return this.isEnchanted(stack) ? Optional.empty() : Optional.of(this.tooltip);
    }

    @Override
    public void addCombinations(List<CombineCraft> combinations) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.ENCHANTED, (Object)true);
        combinations.add(new CombineCraft(ModTags.Items.enchanted_grave_key_ingredients, stack));
    }

    public ItemStack createWithInfo(Player player, Location location) {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!location.isOrigin()) {
            stack.set(ModDataComponents.UNIQUE_IDENTIFIER_NO_SYNC, (Object)player.getGameProfile().getId());
            ModDataComponents.setLocation(stack, location);
        }
        return stack;
    }

    public Optional<UUID> getOwnerId(ItemStack stack) {
        return Optional.ofNullable((UUID)stack.get(ModDataComponents.UNIQUE_IDENTIFIER_NO_SYNC));
    }

    public Location getTombPos(ItemStack stack) {
        return ModDataComponents.getLocation(stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide() && EntityHelper.isValidPlayer(entity) && entity.isAlive() && stack.is((Item)this)) {
            double range;
            ServerPlayer player = (ServerPlayer)entity;
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && location.isSameDimension(level) && (range = player.distanceToSqr((double)location.getPos().getX(), (double)location.getPos().getY(), (double)location.getPos().getZ())) < 43000.0 && Helper.RANDOM.nextInt(range >= 100.0 ? 2400 : (isSelected ? 100 : 300)) == 0 && level.isLoaded(location.getPos())) {
                Optional<BlockEntityPlayerGrave> res = Helper.getPlayerGrave(level, location.getPos());
                boolean bl = isBadKey = res.isEmpty() || this.getOwnerId(stack).map(id -> !id.equals(((BlockEntityPlayerGrave)((Object)((Object)res.get()))).getOwnerId())).orElse(false) != false;
            }
            if (isBadKey) {
                stack.shrink(1);
                player.inventoryMenu.broadcastChanges();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(Player player, BlockEntityPlayerGrave grave) {
        assert (grave.getLevel() != null);
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.is((Item)this) && this.getTombPos((ItemStack)stack).equals(new Location(grave.getBlockPos(), grave.getLevel())) && this.getOwnerId((ItemStack)stack).map(id -> id.equals(grave.getOwnerId())).orElse(false) != false);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)level)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = level.getServer().getLevel(location.dim);
        if (!WorldHelper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        Location spawnPos = new SpawnHelper(targetWorld, location.move(Direction.UP, 1).getPos()).findSpawnPlace();
        if (spawnPos.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            return false;
        }
        stack.set(ModDataComponents.ENCHANTED, (Object)false);
        CallbackHandler.addFastCallback(() -> {
            Player newPlayer = (Player)Helper.teleport(player, spawnPos, targetWorld);
            if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey.get()).booleanValue()) {
                EffectHelper.capDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.teleport_to_grave.trigger(player);
        });
        return true;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    public void reenchantOnDeath(Player player, ItemStack key) {
        if (key.is((Item)this)) {
            int chanceEnchantedKey;
            int n = chanceEnchantedKey = (Boolean)SharedConfigTombstone.magic_item.alwaysEnchantGraveKey.get() != false ? 100 : EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20;
            if (chanceEnchantedKey >= 100 || Helper.RANDOM.nextInt(100) < chanceEnchantedKey) {
                key.set(ModDataComponents.ENCHANTED, (Object)true);
            }
        }
    }

    @Override
    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return super.canBlockInteractFirst(level, pos, stack) || ModBlocks.isPlayerGrave(level.getBlockState(pos).getBlock());
    }
}

