/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.INameable;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModDataComponents;

public class ItemGeneric
extends Item
implements IDisableable,
INameable,
ITab {
    protected final String name;
    private boolean hasEffect = false;
    private boolean defaultInfo = false;
    private boolean isCraftingIngredient = false;
    private boolean canCombine = false;
    private boolean isBeta = false;
    private final BooleanSupplier supplierEnabled;

    public ItemGeneric(String name) {
        this(name, ItemGeneric.getBuilder(), () -> true);
    }

    public ItemGeneric(String name, BooleanSupplier supplierEnabled) {
        this(name, ItemGeneric.getBuilder(), supplierEnabled);
    }

    public ItemGeneric(String name, Item.Properties builder) {
        this(name, builder, () -> true);
    }

    public ItemGeneric(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(builder);
        this.name = name;
        this.supplierEnabled = supplierEnabled;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.supplierEnabled.getAsBoolean();
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withDefaultInfo() {
        this.defaultInfo = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    public ItemGeneric withCombineInfo() {
        this.canCombine = true;
        return this;
    }

    public ItemGeneric withBetaInfo() {
        this.isBeta = true;
        return this;
    }

    public boolean isFoil(ItemStack stack) {
        return this.hasEffect || (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.canCombine) {
            tooltip.add((Component)LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(StyleType.TOOLTIP_COMBINE, new Object[0]));
        }
        if (this.isCraftingIngredient) {
            tooltip.add((Component)LangKey.MESSAGE_CRAFTING_INGREDIENT.getText(StyleType.TOOLTIP_ITEM, new Object[0]));
        }
        if (Helper.canShowTooltip()) {
            if (this.defaultInfo) {
                this.addItemDesc(tooltip);
                this.addItemUse(tooltip);
            }
            this.addTooltipInfo(stack, context, tooltip);
        } else {
            this.addInfo(tooltip, LangKey.TOOLTIP_MORE_INFO, new Object[0]);
        }
        super.appendHoverText(stack, context, tooltip, flag);
        if (this.isBeta) {
            tooltip.add((Component)LangKey.TOOLTIP_BETA.getText(StyleType.TOOLTIP_IN_BETA, new Object[0]));
        }
        if (!this.isEnabled()) {
            this.addWarn(tooltip, LangKey.MESSAGE_DISABLED, new Object[0]);
        }
    }

    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
    }

    public String getDescriptionId() {
        return "tombstone.item." + this.name;
    }

    public String getDescriptionId(ItemStack stack) {
        return this.getDescriptionId();
    }

    public void addPerkInfo(List<Component> tooltip, Perk perk, int level) {
        tooltip.add((Component)perk.getTranslation().plainCopy().append(" " + level).withStyle(StyleType.TOOLTIP_BONUS));
    }

    public void addEffectInfo(List<Component> tooltip, Holder<MobEffect> effectHolder) {
        this.addEffectInfo(tooltip, (MobEffect)effectHolder.value());
    }

    public void addEffectInfo(List<Component> tooltip, MobEffect effect) {
        MutableComponent description;
        TranslatableContents contents;
        String key;
        ComponentContents componentContents = effect.getDisplayName().getContents();
        if (componentContents instanceof TranslatableContents && !(key = "description." + (contents = (TranslatableContents)componentContents).getKey()).equals((description = Component.translatable((String)key)).getString())) {
            tooltip.add((Component)description.withStyle(StyleType.EFFECT_DESCRIPTION));
        }
    }

    public void addItemDesc(List<Component> tooltip) {
        this.addItemDesc(tooltip, "", new Object[0]);
    }

    public void addItemDesc(List<Component> tooltip, String id, Object ... format) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc" + id), (Object[])format).setStyle(StyleType.TOOLTIP_DESC));
    }

    public void addItemUse(List<Component> tooltip) {
        this.addItemUse(tooltip, "", new Object[0]);
    }

    public void addItemUse(List<Component> tooltip, String id, Object ... format) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".use" + id), (Object[])format).setStyle(StyleType.TOOLTIP_USE));
    }

    public void addItemUse(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.TOOLTIP_USE, format));
    }

    public void addInfo(List<Component> tooltip, String key, Object ... format) {
        tooltip.add((Component)Component.translatable((String)key, (Object[])format).setStyle(StyleType.INFO));
    }

    public void addInfo(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.INFO, format));
    }

    public void addWarn(List<Component> tooltip, LangKey langKey, Object ... format) {
        tooltip.add((Component)langKey.getText(StyleType.COLOR_OFF, format));
    }

    public void addItemDistance(List<Component> tooltip, Location location) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            if (!location.isOrigin()) {
                BlockPos pos = player.blockPosition();
                tooltip.add((Component)LangKey.MESSAGE_DISTANCE.getText(ChatFormatting.BLUE, new Object[]{(int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos)}));
            }
        });
    }

    public void addItemPosition(List<Component> tooltip, Location location) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            if (!location.isOrigin()) {
                BlockPos pos = player.blockPosition();
                tooltip.add((Component)LangKey.MESSAGE_DISTANCE.getText(ChatFormatting.BLUE, new Object[]{(int)Helper.getDistance((Vec3i)location.getPos(), (Vec3i)pos)}).append(" ").append((Component)LangKey.MESSAGE_POSITION.getText(location.x, location.y, location.z, location.getDimString())));
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItemSameComponents((ItemStack)oldStack, (ItemStack)newStack);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    protected static Item.Properties getBuilder() {
        return new Item.Properties();
    }
}

