/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.mixin.accessor.VillagerAccessor;

public class ItemGemstoneOfMerchant
extends ItemCastableMagic {
    public ItemGemstoneOfMerchant() {
        super("gemstone_of_merchant", ItemGemstoneOfMerchant.getBuilder().stacksTo(64).fireResistant(), () -> SharedConfigTombstone.allowed_magic_items.allowGemstoneOfMerchant.get());
        this.withDefaultInfo();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        if (target instanceof Merchant) {
            Merchant merchant = (Merchant)target;
            boolean success = false;
            if (target instanceof Villager) {
                Villager villager = (Villager)target;
                if (!villager.isBaby() && villager.getVillagerData().getProfession() != VillagerProfession.NONE && VillagerData.canLevelUp((int)villager.getVillagerData().getLevel())) {
                    villager.setTradingPlayer(null);
                    villager.setVillagerXp(VillagerData.getMaxXpPerLevel((int)villager.getVillagerData().getLevel()));
                    ((VillagerAccessor)villager).callIncreaseMerchantCareer();
                    success = true;
                }
            } else if (!(target instanceof WanderingTrader) && merchant.getVillagerXp() < VillagerData.getMaxXpPerLevel((int)4)) {
                int traderLevel = 1;
                while (merchant.getVillagerXp() >= VillagerData.getMaxXpPerLevel((int)traderLevel)) {
                    ++traderLevel;
                }
                merchant.setTradingPlayer(null);
                merchant.overrideXp(VillagerData.getMaxXpPerLevel((int)traderLevel));
                success = true;
            }
            if (success) {
                LangKey.sendSystemMessage((Player)player, (Component)LangKey.MESSAGE_TRADE_IMPROVED_SUCCESS.getText(new Object[0]));
                return true;
            }
            LangKey.sendSystemMessage((Player)player, (Component)LangKey.MESSAGE_TRADE_IMPROVED_FAILED.getText(new Object[0]));
        }
        return false;
    }

    @Override
    protected boolean isTargetForCasting(Player player, @Nullable LivingEntity target) {
        return target instanceof Merchant;
    }

    @Override
    protected ItemCastableMagic.CastingTarget getCastingTarget(ItemStack stack) {
        return ItemCastableMagic.CastingTarget.TARGET_ONLY;
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

